/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.resolution;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.resolution.ArtifactResolverPostProcessorSupport;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmHelper;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

@Singleton
@Named(value="trustedChecksums")
public final class TrustedChecksumsArtifactResolverPostProcessor
extends ArtifactResolverPostProcessorSupport {
    public static final String NAME = "trustedChecksums";
    private static final String CONF_NAME_CHECKSUM_ALGORITHMS = "checksumAlgorithms";
    private static final String DEFAULT_CHECKSUM_ALGORITHMS = "SHA-1";
    private static final String CONF_NAME_FAIL_IF_MISSING = "failIfMissing";
    private static final String CONF_NAME_SNAPSHOTS = "snapshots";
    private static final String CONF_NAME_RECORD = "record";
    private static final String CHECKSUM_ALGORITHMS_CACHE_KEY = TrustedChecksumsArtifactResolverPostProcessor.class.getName() + ".checksumAlgorithms";
    private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;
    private final Map<String, TrustedChecksumsSource> trustedChecksumsSources;

    @Inject
    public TrustedChecksumsArtifactResolverPostProcessor(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector, Map<String, TrustedChecksumsSource> trustedChecksumsSources) {
        super(NAME);
        this.checksumAlgorithmFactorySelector = Objects.requireNonNull(checksumAlgorithmFactorySelector);
        this.trustedChecksumsSources = Objects.requireNonNull(trustedChecksumsSources);
    }

    @Override
    protected void doPostProcess(RepositorySystemSession session, List<ArtifactResult> artifactResults) {
        List checksumAlgorithms = (List)session.getData().computeIfAbsent(CHECKSUM_ALGORITHMS_CACHE_KEY, () -> this.checksumAlgorithmFactorySelector.selectList(ConfigUtils.parseCommaSeparatedUniqueNames((String)ConfigUtils.getString(session, DEFAULT_CHECKSUM_ALGORITHMS, this.configPropKey(CONF_NAME_CHECKSUM_ALGORITHMS)))));
        boolean failIfMissing = ConfigUtils.getBoolean(session, false, this.configPropKey(CONF_NAME_FAIL_IF_MISSING));
        boolean record = ConfigUtils.getBoolean(session, false, this.configPropKey(CONF_NAME_RECORD));
        boolean snapshots = ConfigUtils.getBoolean(session, false, this.configPropKey(CONF_NAME_SNAPSHOTS));
        for (ArtifactResult artifactResult : artifactResults) {
            if (artifactResult.getArtifact().isSnapshot() && !snapshots || !artifactResult.isResolved()) continue;
            if (record) {
                this.recordArtifactChecksums(session, artifactResult, checksumAlgorithms);
                continue;
            }
            if (this.validateArtifactChecksums(session, artifactResult, checksumAlgorithms, failIfMissing)) continue;
            artifactResult.setArtifact(artifactResult.getArtifact().setFile(null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recordArtifactChecksums(RepositorySystemSession session, ArtifactResult artifactResult, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        Artifact artifact = artifactResult.getArtifact();
        ArtifactRepository artifactRepository = artifactResult.getRepository();
        try {
            Map<String, String> calculatedChecksums = ChecksumAlgorithmHelper.calculate(artifact.getFile(), checksumAlgorithmFactories);
            for (TrustedChecksumsSource trustedChecksumsSource : this.trustedChecksumsSources.values()) {
                TrustedChecksumsSource.Writer writer = trustedChecksumsSource.getTrustedArtifactChecksumsWriter(session);
                if (writer == null) continue;
                try {
                    writer.addTrustedArtifactChecksums(artifact, artifactRepository, checksumAlgorithmFactories, calculatedChecksums);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not write required checksums for " + artifact.getFile(), e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not calculate required checksums for " + artifact.getFile(), e);
        }
    }

    private boolean validateArtifactChecksums(RepositorySystemSession session, ArtifactResult artifactResult, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories, boolean failIfMissing) {
        Artifact artifact = artifactResult.getArtifact();
        ArtifactRepository artifactRepository = artifactResult.getRepository();
        boolean valid = true;
        boolean validated = false;
        try {
            Map<String, String> calculatedChecksums = ChecksumAlgorithmHelper.calculate(artifact.getFile(), checksumAlgorithmFactories);
            for (Map.Entry<String, TrustedChecksumsSource> entry : this.trustedChecksumsSources.entrySet()) {
                String trustedSourceName = entry.getKey();
                TrustedChecksumsSource trustedChecksumsSource = entry.getValue();
                Map<String, String> trustedChecksums = trustedChecksumsSource.getTrustedArtifactChecksums(session, artifact, artifactRepository, checksumAlgorithmFactories);
                if (trustedChecksums == null) continue;
                validated = true;
                if (calculatedChecksums.equals(trustedChecksums)) continue;
                HashSet<String> missingTrustedAlg = new HashSet<String>(calculatedChecksums.keySet());
                missingTrustedAlg.removeAll(trustedChecksums.keySet());
                if (!missingTrustedAlg.isEmpty() && failIfMissing) {
                    artifactResult.addException(new ChecksumFailureException("Missing from " + trustedSourceName + " trusted checksum(s) " + missingTrustedAlg + " for artifact " + ArtifactIdUtils.toId(artifact)));
                    valid = false;
                }
                for (ChecksumAlgorithmFactory checksumAlgorithmFactory : checksumAlgorithmFactories) {
                    String calculatedChecksum = calculatedChecksums.get(checksumAlgorithmFactory.getName());
                    String trustedChecksum = trustedChecksums.get(checksumAlgorithmFactory.getName());
                    if (trustedChecksum == null || Objects.equals(calculatedChecksum, trustedChecksum)) continue;
                    artifactResult.addException(new ChecksumFailureException("Artifact " + ArtifactIdUtils.toId(artifact) + " trusted checksum mismatch: " + trustedSourceName + "=" + trustedChecksum + "; calculated=" + calculatedChecksum));
                    valid = false;
                }
            }
            if (!validated && failIfMissing) {
                artifactResult.addException(new ChecksumFailureException("There are no enabled trusted checksums source(s) to validate against."));
                valid = false;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return valid;
    }
}

