/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.operation.ServiceController;
import io.intino.consul.terminal.RequestAttendant;
import jakarta.jms.JMSException;
import jakarta.jms.Message;

public class DebugApplicationRequest
implements RequestAttendant {
    public static final String ID = "debug";
    private final Activity.Context context;
    private final Activity.Store store;

    public DebugApplicationRequest(Activity.Context context, Activity.Store store) {
        this.context = context;
        this.store = store;
    }

    public String id() {
        return ID;
    }

    public RequestAttendant.RequestResult responseTo(Message request) {
        try {
            Service service = (Service)this.store.get(this.parameter(request, "observable"), Service.class);
            if (service == null) {
                return new RequestAttendant.RequestResult(false, (Object)"Service not found");
            }
            return new RequestAttendant.RequestResult(new ServiceController(this.context, this.store).debug(service), (Object)"");
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return new RequestAttendant.RequestResult(false, (Object)e.getMessage());
        }
    }

    public boolean isAvailable(Message message) {
        try {
            Service service = (Service)this.store.get(this.parameter(message, "observable"), Service.class);
            return service != null && !this.isDebuging(service);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    private boolean isDebuging(Service service) {
        return service.status().equals((Object)Service.Status.Debug);
    }
}

