/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.operation;

import io.intino.alexandria.jmx.JMXClient;
import io.intino.alexandria.jmx.Parameters;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.framework.utils.JMXConnection;
import io.intino.consul.framework.utils.Utils;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.cosmos.datahub.messages.universe.ObservableAssertion;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JavaApplicationConnector {
    private final Activity.System system;

    public JavaApplicationConnector(Activity.System system) {
        this.system = system;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ObservableAssertion.Operation.Procedure> proceduresOf(Service service) {
        try (JMXConnection connection = JMXConnection.connection((Activity.System)this.system, (String)("localhost\u0000\u0000" + service.managementPort()));){
            Utils.Coors coors = this.coors(connection.get());
            if (!coors.id().equals(service.artifact().identifier())) return Collections.emptyList();
            List<ObservableAssertion.Operation.Procedure> list = this.procedures(connection.get());
            return list;
        }
        catch (IOException e) {
            Logger.error((String)e.getMessage());
        }
        return Collections.emptyList();
    }

    private List<ObservableAssertion.Operation.Procedure> procedures(JMXClient.JMXConnection connection) {
        return connection.beans().stream().filter(b -> !JavaApplicationConnector.isJavaObject(b)).flatMap(b -> this.procedures(connection, (ObjectName)b).stream()).toList();
    }

    private List<ObservableAssertion.Operation.Procedure> procedures(JMXClient.JMXConnection connection, ObjectName objectName) {
        try {
            MBeanInfo mBean = connection.mBeanInfo(objectName);
            Map infos = connection.operationInfos(objectName);
            return infos.entrySet().stream().map(e -> this.map(mBean.getClassName(), (MBeanOperationInfo)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }
        catch (IOException | InstanceNotFoundException | IntrospectionException | ReflectionException e2) {
            Logger.error((Throwable)e2);
            return Collections.emptyList();
        }
    }

    private ObservableAssertion.Operation.Procedure map(String className, MBeanOperationInfo info, String description) {
        return new ObservableAssertion.Operation.Procedure().name(className + "::" + info.getName()).description(description).parameterList(this.parameters(info));
    }

    private List<ObservableAssertion.Operation.Procedure.Parameter> parameters(MBeanOperationInfo info) {
        String[] parameters = (String[])info.getDescriptor().getFieldValue(Parameters.class.getSimpleName());
        ArrayList<ObservableAssertion.Operation.Procedure.Parameter> list = new ArrayList<ObservableAssertion.Operation.Procedure.Parameter>();
        MBeanParameterInfo[] parametersInfo = info.getSignature();
        int signatureLength = parametersInfo.length;
        for (int i = 0; i < signatureLength; ++i) {
            MBeanParameterInfo mb = parametersInfo[i];
            list.add(new ObservableAssertion.Operation.Procedure.Parameter().name(parameters != null ? parameters[i] : mb.getName()).type(mb.getType()));
        }
        return list;
    }

    private Utils.Coors coors(JMXClient.JMXConnection connection) {
        RuntimeMXBean runtime = (RuntimeMXBean)connection.mBean(RuntimeMXBean.class, ManagementFactory.getRuntimeMXBean().getObjectName());
        return this.coors(Arrays.asList(runtime.getClassPath().split(File.pathSeparator)));
    }

    private Utils.Coors coors(List<String> classpath) {
        if (classpath.isEmpty()) {
            return new Utils.Coors("", "", "");
        }
        File mainArtifact = new File(classpath.get(0));
        return Utils.coors((Activity.System)this.system, (File)mainArtifact);
    }

    private static boolean isJavaObject(ObjectName name) {
        String canonicalName = name.getCanonicalName();
        return canonicalName.startsWith("java.") || canonicalName.startsWith("jdk.") || canonicalName.startsWith("com.sun.");
    }
}

