/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.deployment.windows;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.deployment.windows.GZipUncompress;
import io.intino.consul.javaoperationactivity.deployment.windows.WrapperConfTemplate;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.IntStream;

public class WindowsServiceGenerator {
    private final Service service;
    private final String serviceShortName;
    private final File applicationsDirectory;
    private final File logsDirectory;
    private final File tmpDirectory;
    private final String javaHome;
    private final Activity.System.OperatingSystem os;
    private final String deployUser;

    public WindowsServiceGenerator(Service service, Activity.Context context) throws Exception {
        this.service = service;
        this.serviceShortName = service.shortName();
        this.os = context.system().operatingSystem();
        this.applicationsDirectory = new File((String)context.initialConfiguration().get("applications-directory"));
        this.deployUser = (String)context.initialConfiguration().get("deploy-user");
        this.logsDirectory = new File((String)context.initialConfiguration().get("logs-directory"));
        this.tmpDirectory = new File((String)context.initialConfiguration().get("tmp-directory"));
        this.javaHome = (String)context.initialConfiguration().get("java-home");
    }

    public void create(boolean debug) throws Exception {
        try {
            Logger.info((String)"Creating service...");
            File dir = this.applicationDirectory();
            dir.mkdirs();
            this.installWrapper(dir);
            this.configWrapper(dir, debug);
            this.installService(dir);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    private void installWrapper(File dir) throws Exception {
        File wrapper = new File(dir, "wrapper.tar");
        if (wrapper.exists()) {
            return;
        }
        this.decompress(wrapper, dir);
    }

    private void configWrapper(File dir, boolean debug) throws IOException {
        String render = new WrapperConfTemplate().render(this.frame(debug));
        File file = new File(dir, "win64" + File.separator + "wrapper.conf");
        file.getParentFile().mkdirs();
        this.os.fileSystem().writeString(file.getAbsolutePath(), render);
    }

    private void installService(File dir) throws Exception {
        File installService = new File(dir, "win64" + File.separator + "InstallService.bat");
        Logger.info((String)this.os.processRunner().execute(List.of(installService.getAbsolutePath()), 5));
    }

    private void decompress(File tar, File dir) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("wrapper.tar");
        if (stream == null) {
            throw new IOException("Resource wrapper.tar not found");
        }
        WindowsServiceGenerator.copy(stream, new FileOutputStream(tar));
        GZipUncompress.uncompressTarGZ(tar, dir);
    }

    private File applicationDirectory() {
        return new File(this.applicationsDirectory, this.serviceShortName).getAbsoluteFile();
    }

    private Frame frame(boolean debug) {
        FrameBuilder builder = new FrameBuilder("wrapper").add("artifact", this.serviceShortName).add("artifactFile", this.service.artifact().artifactId() + "-" + this.service.artifact().version()).add("service", this.serviceName()).add("applicationsDirectory", this.applicationsDirectory.getAbsolutePath()).add("logsDirectory", this.logsDirectory.getAbsolutePath()).add("java", this.javaHome != null ? this.javaHome.replace("\"", "") : System.getProperty("java.home")).add("managementPort", this.service.managementPort()).add("parameter", this.parameters());
        if (this.tmpDirectory != null) {
            builder.add("tmp", this.tmpDirectory.getAbsolutePath());
        }
        if (debug) {
            builder.add("debug", this.service.debugPort());
        }
        if (this.service.artifact().mainClass() != null) {
            builder.add("mainClass", this.service.artifact().mainClass());
        }
        if (this.service.artifact().classpathPrefix() != null) {
            builder.add("classpathDirectory", this.service.artifact().classpathPrefix());
        }
        if (this.service.requirements() != null && this.service.requirements().minMemory() > 0) {
            builder.add("minMemory", this.service.requirements().minMemory());
        }
        if (this.service.requirements() != null && this.service.requirements().maxMemory() > 0) {
            builder.add("maxMemory", this.service.requirements().maxMemory());
        }
        return builder.toFrame();
    }

    private String serviceName() {
        return this.deployUser + "-" + this.service.artifact().artifactId();
    }

    private Frame[] parameters() {
        List<Service.Parameter> parameters = this.service.parameterList();
        return (Frame[])IntStream.range(0, parameters.size()).mapToObj(p -> new FrameBuilder("parameter").add("index", p + 2).add("name", ((Service.Parameter)parameters.get(p)).name()).add("value", ((Service.Parameter)parameters.get(p)).value()).toFrame()).toArray(Frame[]::new);
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }
}

