/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.TypeLiteral;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.bean.DeclaredMembers;
import org.eclipse.sisu.plexus.TypeArguments;

public final class CompositeBeanHelper {
    private final ConverterLookup lookup;
    private final ClassLoader loader;
    private final ExpressionEvaluator evaluator;
    private final ConfigurationListener listener;

    public CompositeBeanHelper(ConverterLookup lookup, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) {
        this.lookup = lookup;
        this.loader = loader;
        this.evaluator = evaluator;
        this.listener = listener;
    }

    public void setDefault(Object bean, Object defaultValue, PlexusConfiguration configuration) throws ComponentConfigurationException {
        Type[] paramTypeHolder;
        Class<?> beanType = bean.getClass();
        Method setter = CompositeBeanHelper.findMethod(beanType, paramTypeHolder = new Type[1], "set", null);
        if (null == setter) {
            throw new ComponentConfigurationException(configuration, "Cannot find default setter in " + beanType);
        }
        Object value = defaultValue;
        TypeLiteral<?> paramType = TypeLiteral.get(paramTypeHolder[0]);
        if (!paramType.getRawType().isInstance(value)) {
            if (configuration.getChildCount() > 0) {
                throw new ComponentConfigurationException("Basic element '" + configuration.getName() + "' must not contain child elements");
            }
            value = this.convertProperty(beanType, paramType.getRawType(), paramType.getType(), configuration);
        }
        if (null != value) {
            try {
                if (null != this.listener) {
                    this.listener.notifyFieldChangeUsingSetter("", value, bean);
                }
                setter.invoke(bean, value);
            }
            catch (Exception e) {
                throw new ComponentConfigurationException(configuration, "Cannot set default", e);
            }
            catch (LinkageError e) {
                throw new ComponentConfigurationException(configuration, "Cannot set default", e);
            }
        }
    }

    public void setProperty(Object bean, String propertyName, Class<?> valueType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        String reason;
        Field field;
        Throwable problem;
        Method setter;
        Class<?> beanType;
        block20: {
            beanType = bean.getClass();
            Type[] paramTypeHolder = new Type[1];
            String title = Character.toTitleCase(propertyName.charAt(0)) + propertyName.substring(1);
            setter = CompositeBeanHelper.findMethod(beanType, paramTypeHolder, "set" + title, valueType);
            if (null == setter) {
                setter = CompositeBeanHelper.findMethod(beanType, paramTypeHolder, "add" + title, valueType);
            }
            problem = null;
            Object value = null;
            if (null != setter) {
                try {
                    TypeLiteral<?> paramType = TypeLiteral.get(paramTypeHolder[0]);
                    Class<?> rawPropertyType = paramType.getRawType();
                    if (null != valueType && rawPropertyType.isAssignableFrom(valueType)) {
                        rawPropertyType = valueType;
                    }
                    if (null != (value = this.convertProperty(beanType, rawPropertyType, paramType.getType(), configuration))) {
                        if (null != this.listener) {
                            this.listener.notifyFieldChangeUsingSetter(propertyName, value, bean);
                        }
                        setter.invoke(bean, value);
                        return;
                    }
                }
                catch (Exception e) {
                    problem = e;
                }
                catch (LinkageError e) {
                    problem = e;
                }
            }
            if (null != (field = CompositeBeanHelper.findField(beanType, propertyName))) {
                try {
                    TypeLiteral<?> fieldType = TypeLiteral.get(field.getGenericType());
                    Class<?> rawPropertyType = fieldType.getRawType();
                    if (!rawPropertyType.isInstance(value)) {
                        if (null != valueType && rawPropertyType.isAssignableFrom(valueType)) {
                            rawPropertyType = valueType;
                        }
                        value = this.convertProperty(beanType, rawPropertyType, fieldType.getType(), configuration);
                    }
                    if (null != value) {
                        if (null != this.listener) {
                            this.listener.notifyFieldChangeUsingReflection(propertyName, value, bean);
                        }
                        CompositeBeanHelper.setField(bean, field, value);
                        return;
                    }
                }
                catch (Exception e) {
                    if (null == problem) {
                        problem = e;
                    }
                }
                catch (LinkageError e) {
                    if (null != problem) break block20;
                    problem = e;
                }
            }
        }
        if (problem instanceof ComponentConfigurationException) {
            throw (ComponentConfigurationException)problem;
        }
        if (null != problem) {
            reason = "Cannot set '" + propertyName + "' in " + beanType;
            throw new ComponentConfigurationException(configuration, reason, problem);
        }
        if (null == setter && null == field) {
            reason = "Cannot find '" + propertyName + "' in " + beanType;
            throw new ComponentConfigurationException(configuration, reason);
        }
    }

    private Object convertProperty(Class<?> beanType, Class<?> rawPropertyType, Type genericPropertyType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        ConfigurationConverter converter = this.lookup.lookupConverterForType(rawPropertyType);
        if (!(genericPropertyType instanceof Class) && converter instanceof ParameterizedConfigurationConverter) {
            Type[] propertyTypeArgs = TypeArguments.get(genericPropertyType);
            return ((ParameterizedConfigurationConverter)converter).fromConfiguration(this.lookup, configuration, rawPropertyType, propertyTypeArgs, beanType, this.loader, this.evaluator, this.listener);
        }
        return converter.fromConfiguration(this.lookup, configuration, rawPropertyType, beanType, this.loader, this.evaluator, this.listener);
    }

    private static Method findMethod(Class<?> beanType, Type[] paramTypeHolder, String methodName, Class<?> valueType) {
        Method candidate = null;
        for (Method m : beanType.getMethods()) {
            Type[] paramTypes;
            if (!methodName.equals(m.getName()) || Modifier.isStatic(m.getModifiers()) || (paramTypes = m.getGenericParameterTypes()).length != 1) continue;
            if (valueType != null && m.getParameters()[0].getType().isAssignableFrom(valueType)) {
                paramTypeHolder[0] = paramTypes[0];
                return m;
            }
            if (candidate != null) continue;
            paramTypeHolder[0] = paramTypes[0];
            candidate = m;
        }
        return candidate;
    }

    private static Field findField(Class<?> beanType, String fieldName) {
        for (Member f : new DeclaredMembers(beanType, DeclaredMembers.View.FIELDS)) {
            if (!fieldName.equals(f.getName()) || Modifier.isStatic(f.getModifiers())) continue;
            return (Field)f;
        }
        return null;
    }

    private static void setField(Object bean, final Field field, Object value) throws Exception {
        if (!field.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
        field.set(bean, value);
    }
}

