/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.LifecycleManager;

public final class LifecycleModule
implements Module {
    private final Matcher<TypeLiteral<?>> matcher = new AbstractMatcher<TypeLiteral<?>>(){

        @Override
        public boolean matches(TypeLiteral<?> type) {
            return LifecycleModule.this.manager.manage(type.getRawType());
        }
    };
    private final TypeListener typeListener = new TypeListener(){
        private final InjectionListener<Object> listener = new InjectionListener<Object>(){

            @Override
            public void afterInjection(Object bean) {
                LifecycleModule.this.manager.manage(bean);
            }
        };

        public <B> void hear(TypeLiteral<B> type, TypeEncounter<B> encounter) {
            encounter.register(this.listener);
        }
    };
    final BeanManager manager;

    public LifecycleModule() {
        this(new LifecycleManager());
    }

    public LifecycleModule(BeanManager manager) {
        this.manager = manager;
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(BeanManager.class).toInstance(this.manager);
        binder.bindListener(this.matcher, this.typeListener);
    }
}

