/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.PluginValidationManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.internal.AbstractMavenPluginDescriptorSourcedParametersValidator;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

@Singleton
@Named
class DeprecatedPluginValidator
extends AbstractMavenPluginDescriptorSourcedParametersValidator {
    @Inject
    DeprecatedPluginValidator(PluginValidationManager pluginValidationManager) {
        super(pluginValidationManager);
    }

    @Override
    protected String getParameterLogReason(Parameter parameter) {
        return "is deprecated: " + parameter.getDeprecated();
    }

    @Override
    protected void doValidate(MavenSession mavenSession, MojoDescriptor mojoDescriptor, Class<?> mojoClass, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        if (mojoDescriptor.getDeprecated() != null) {
            this.pluginValidationManager.reportPluginMojoValidationIssue(PluginValidationManager.IssueLocality.INTERNAL, mavenSession, mojoDescriptor, mojoClass, this.logDeprecatedMojo(mojoDescriptor));
        }
        if (mojoDescriptor.getParameters() != null) {
            mojoDescriptor.getParameters().stream().filter(parameter -> parameter.getDeprecated() != null).filter(Parameter::isEditable).forEach(parameter -> this.checkParameter(mavenSession, mojoDescriptor, mojoClass, (Parameter)parameter, pomConfiguration, expressionEvaluator));
        }
    }

    private void checkParameter(MavenSession mavenSession, MojoDescriptor mojoDescriptor, Class<?> mojoClass, Parameter parameter, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        PlexusConfiguration config = pomConfiguration.getChild(parameter.getName(), false);
        if (this.isValueSet(config, expressionEvaluator)) {
            this.pluginValidationManager.reportPluginMojoValidationIssue(PluginValidationManager.IssueLocality.INTERNAL, mavenSession, mojoDescriptor, mojoClass, this.formatParameter(parameter));
        }
    }

    private String logDeprecatedMojo(MojoDescriptor mojoDescriptor) {
        return MessageUtils.buffer().warning("Goal '").warning(mojoDescriptor.getGoal()).warning("' is deprecated: ").warning(mojoDescriptor.getDeprecated()).toString();
    }
}

