/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.service;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.service.requests.DebugApplicationRequest;
import io.intino.consul.javaoperationactivity.service.requests.DeployApplicationRequest;
import io.intino.consul.javaoperationactivity.service.requests.ExecuteOperationRequest;
import io.intino.consul.terminal.RequestAttendant;
import io.intino.cosmos.datahub.messages.universe.ObservableAssertion;
import java.util.List;

public class JavaOperationService {
    public static final String SEP = "#";
    public static final Object monitor = new Object();
    private final String activityID;
    private final Activity.Context context;
    private final Activity.Store store;

    public JavaOperationService(String activityID, Activity.Context context, Activity.Store store) {
        this.activityID = activityID;
        this.context = context;
        this.store = store;
    }

    public void start() {
        this.context.terminal().service().register(this.activityID + "#deploy", (RequestAttendant)new DeployApplicationRequest(this.context, this.store));
        this.context.terminal().service().register(this.activityID + "#debug", (RequestAttendant)new DebugApplicationRequest(this.context, this.store));
        this.context.terminal().service().register(this.activityID + "#execute-procedure", (RequestAttendant)new ExecuteOperationRequest(this.context, this.store));
    }

    public void stop() {
        try {
            this.context.terminal().service().unregister(this.activityID + "#deploy");
            this.context.terminal().service().unregister(this.activityID + "#debug");
            this.context.terminal().service().unregister(this.activityID + "#execute-procedure");
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
        }
    }

    public static List<ObservableAssertion.Operation> activityOperations() {
        return List.of(new ObservableAssertion.Operation().name("deploy").activity("java-operation-activity"), new ObservableAssertion.Operation().name("debug").activity("java-operation-activity"), new ObservableAssertion.Operation().name("execute-procedure").activity("java-operation-activity"));
    }
}

