/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.operation.deploy;

import io.intino.consul.javaoperationactivity.box.schemas.Service;
import java.util.Map;
import org.apache.maven.settings.Server;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public class MavenRepositories {
    public static RemoteRepository repository(Service.Artifact.Artifactory r, Map<String, Server> servers) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(r.mavenId(), "default", r.url()).setAuthentication(MavenRepositories.authentication(r.mavenId(), servers));
        if (r.snapshot().booleanValue()) {
            builder.setSnapshotPolicy(new RepositoryPolicy(true, "always", "warn")).setReleasePolicy(new RepositoryPolicy(false, "always", "warn"));
        } else {
            builder.setSnapshotPolicy(new RepositoryPolicy(false, "always", "warn")).setReleasePolicy(new RepositoryPolicy(true, "always", "warn"));
        }
        return MavenRepositories.addProxies(builder, r.url()).build();
    }

    public static Authentication authentication(String mavenId, Map<String, Server> servers) {
        return servers.keySet().stream().filter(credential -> credential.equals(mavenId)).findFirst().map(c -> new AuthenticationBuilder().addUsername(((Server)servers.get(c)).getUsername()).addPassword(((Server)servers.get(c)).getPassword()).build()).orElse(null);
    }

    public static RemoteRepository.Builder addProxies(RemoteRepository.Builder r, String url) {
        if (System.getProperty("http.proxyHost") != null) {
            r.setProxy(new Proxy("http", System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")), null));
        }
        return r;
    }
}

