/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.box.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Deploy
implements Serializable {
    private String id;
    private String project;
    private String classpathPrefix;
    private String artifact;
    private String mainClass;
    private Requirements requirements;
    private List<Parameter> parameter = new ArrayList<Parameter>();
    private List<JVMParameter> jVMParameter = new ArrayList<JVMParameter>();
    private List<Artifactory> artifactory = new ArrayList<Artifactory>();

    public String id() {
        return this.id;
    }

    public String project() {
        return this.project;
    }

    public String classpathPrefix() {
        return this.classpathPrefix;
    }

    public String artifact() {
        return this.artifact;
    }

    public String mainClass() {
        return this.mainClass;
    }

    public Requirements requirements() {
        return this.requirements;
    }

    public List<Parameter> parameterList() {
        return this.parameter;
    }

    public List<Parameter> parameterList(Predicate<Parameter> predicate) {
        return this.parameter.stream().filter(predicate).collect(Collectors.toList());
    }

    public Parameter parameter(Predicate<Parameter> predicate) {
        return this.parameter.stream().filter(predicate).findFirst().orElse(null);
    }

    public List<JVMParameter> jVMParameterList() {
        return this.jVMParameter;
    }

    public List<JVMParameter> jVMParameterList(Predicate<JVMParameter> predicate) {
        return this.jVMParameter.stream().filter(predicate).collect(Collectors.toList());
    }

    public JVMParameter jVMParameter(Predicate<JVMParameter> predicate) {
        return this.jVMParameter.stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Artifactory> artifactoryList() {
        return this.artifactory;
    }

    public List<Artifactory> artifactoryList(Predicate<Artifactory> predicate) {
        return this.artifactory.stream().filter(predicate).collect(Collectors.toList());
    }

    public Artifactory artifactory(Predicate<Artifactory> predicate) {
        return this.artifactory.stream().filter(predicate).findFirst().orElse(null);
    }

    public Deploy id(String id) {
        this.id = id;
        return this;
    }

    public Deploy project(String project) {
        this.project = project;
        return this;
    }

    public Deploy classpathPrefix(String classpathPrefix) {
        this.classpathPrefix = classpathPrefix;
        return this;
    }

    public Deploy artifact(String artifact) {
        this.artifact = artifact;
        return this;
    }

    public Deploy mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public Deploy requirements(Requirements requirements) {
        this.requirements = requirements;
        return this;
    }

    public Deploy parameterList(List<Parameter> parameter) {
        this.parameter = parameter;
        return this;
    }

    public Deploy jVMParameterList(List<JVMParameter> jVMParameter) {
        this.jVMParameter = jVMParameter;
        return this;
    }

    public Deploy artifactoryList(List<Artifactory> artifactory) {
        this.artifactory = artifactory;
        return this;
    }

    public static class Requirements
    implements Serializable {
        private int minMemory = 0;
        private int maxMemory = 0;
        private List<SyncFileToServer> syncFileToServer = new ArrayList<SyncFileToServer>();

        public int minMemory() {
            return this.minMemory;
        }

        public int maxMemory() {
            return this.maxMemory;
        }

        public List<SyncFileToServer> syncFileToServerList() {
            return this.syncFileToServer;
        }

        public List<SyncFileToServer> syncFileToServerList(Predicate<SyncFileToServer> predicate) {
            return this.syncFileToServer.stream().filter(predicate).collect(Collectors.toList());
        }

        public SyncFileToServer syncFileToServer(Predicate<SyncFileToServer> predicate) {
            return this.syncFileToServer.stream().filter(predicate).findFirst().orElse(null);
        }

        public Requirements minMemory(int minMemory) {
            this.minMemory = minMemory;
            return this;
        }

        public Requirements maxMemory(int maxMemory) {
            this.maxMemory = maxMemory;
            return this;
        }

        public Requirements syncFileToServerList(List<SyncFileToServer> syncFileToServer) {
            this.syncFileToServer = syncFileToServer;
            return this;
        }

        public static class SyncFileToServer
        implements Serializable {
            private String directory;
            private List<String> targetServers = new ArrayList<String>();

            public String directory() {
                return this.directory;
            }

            public List<String> targetServers() {
                return this.targetServers;
            }

            public SyncFileToServer directory(String directory) {
                this.directory = directory;
                return this;
            }

            public SyncFileToServer targetServers(List<String> targetServers) {
                this.targetServers = targetServers;
                return this;
            }
        }
    }

    public static class Parameter
    implements Serializable {
        private String name;
        private String value;

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public Parameter name(String name) {
            this.name = name;
            return this;
        }

        public Parameter value(String value) {
            this.value = value;
            return this;
        }
    }

    public static class JVMParameter
    implements Serializable {
        private String value;

        public String value() {
            return this.value;
        }

        public JVMParameter value(String value) {
            this.value = value;
            return this;
        }
    }

    public static class Artifactory
    implements Serializable {
        private String id;
        private String url;
        private String user;
        private String password;

        public String id() {
            return this.id;
        }

        public String url() {
            return this.url;
        }

        public String user() {
            return this.user;
        }

        public String password() {
            return this.password;
        }

        public Artifactory id(String id) {
            this.id = id;
            return this;
        }

        public Artifactory url(String url) {
            this.url = url;
            return this;
        }

        public Artifactory user(String user) {
            this.user = user;
            return this;
        }

        public Artifactory password(String password) {
            this.password = password;
            return this;
        }
    }
}

