/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.template.condition.predicates;

import io.intino.itrules.Trigger;
import io.intino.itrules.template.condition.Predicate;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class TypePredicate
implements Predicate {
    private final Checker checker;
    private final String[] types;

    public TypePredicate(String ... types) {
        this.types = types;
        this.checker = types.length > 1 ? this.multiple(this.setOf(types)) : this.single(types[0].toLowerCase());
    }

    @Override
    public boolean evaluate(Trigger trigger) {
        return this.checker.check(trigger);
    }

    public String[] types() {
        return this.types;
    }

    private Checker multiple(Set<String> types) {
        return trigger -> types.stream().allMatch(t -> trigger.frame().is((String)t));
    }

    private Checker single(String type) {
        return trigger -> trigger.frame().is(type);
    }

    private Set<String> setOf(String[] types) {
        return Arrays.stream(types).map(String::toLowerCase).collect(Collectors.toSet());
    }

    public String toString() {
        return "type(" + String.join((CharSequence)", ", this.types) + ")";
    }

    static interface Checker {
        public boolean check(Trigger var1);
    }
}

