/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.box;

import io.intino.alexandria.core.Box;
import io.intino.consul.javaoperationactivity.box.JavaOperationActivityConfiguration;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends Box {
    protected JavaOperationActivityConfiguration configuration;

    public AbstractBox(String[] args) {
        this(new JavaOperationActivityConfiguration(args));
    }

    public AbstractBox(JavaOperationActivityConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    @Override
    public JavaOperationActivityConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Box put(Object o) {
        return this;
    }

    @Override
    public abstract void beforeStart();

    @Override
    public Box start() {
        this.initConnector();
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    @Override
    public abstract void afterStart();

    @Override
    public abstract void beforeStop();

    @Override
    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    @Override
    public void stopServices() {
    }

    @Override
    public abstract void afterStop();

    @Override
    public void startServices() {
        this.initUI();
        this.initAgenda();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.initCli();
    }

    private void initRestServices() {
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
    }

    protected void initConnector() {
    }

    protected void initTerminal() {
    }

    protected void initSentinels() {
    }

    protected void initWorkflow() {
    }

    protected void initAgenda() {
    }

    protected void initCli() {
    }

    protected void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new io.intino.alexandria.logger.Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
    }

    public static URL url(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return null;
        }
    }
}

