/*
 * Decompiled with CFR 0.152.
 */
package smile.wavelet;

import smile.math.MathEx;
import smile.wavelet.Wavelet;

public interface WaveletShrinkage {
    public static void denoise(double[] t2, Wavelet wavelet) {
        WaveletShrinkage.denoise(t2, wavelet, false);
    }

    public static void denoise(double[] t2, Wavelet wavelet, boolean soft) {
        wavelet.transform(t2);
        int n = t2.length;
        int nh = t2.length >> 1;
        double[] wc = new double[nh];
        System.arraycopy(t2, nh, wc, 0, nh);
        double error = MathEx.mad(wc) / 0.6745;
        double lambda = error * Math.sqrt(2.0 * Math.log(n));
        if (soft) {
            for (int i = 2; i < n; ++i) {
                t2[i] = Math.signum(t2[i]) * Math.max(Math.abs(t2[i]) - lambda, 0.0);
            }
        } else {
            for (int i = 2; i < n; ++i) {
                if (!(Math.abs(t2[i]) < lambda)) continue;
                t2[i] = 0.0;
            }
        }
        wavelet.inverse(t2);
    }
}

