/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.type;

import java.util.Arrays;
import org.apache.commons.math3.exception.DimensionMismatchException;

public class MatrixProfile
implements Cloneable {
    private final double[] profile;
    private final int[] indexProfile;

    public MatrixProfile(double[] profile, int[] indexProfile) {
        if (profile.length != indexProfile.length) {
            throw new DimensionMismatchException(profile.length, indexProfile.length);
        }
        this.profile = profile;
        this.indexProfile = indexProfile;
    }

    public MatrixProfile(int size) {
        this.profile = new double[size];
        this.indexProfile = new int[size];
        for (int j = 0; j < size; ++j) {
            this.profile[j] = Double.POSITIVE_INFINITY;
            this.indexProfile[j] = -1;
        }
    }

    public MatrixProfile clone() {
        int size = this.profile.length;
        MatrixProfile copy = new MatrixProfile(size);
        for (int i = 0; i < size; ++i) {
            copy.profile[i] = this.profile[i];
            copy.indexProfile[i] = this.indexProfile[i];
        }
        return copy;
    }

    public double[] getProfile() {
        return this.profile;
    }

    public int[] getIndexProfile() {
        return this.indexProfile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatrixProfile)) {
            return false;
        }
        MatrixProfile other = (MatrixProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getProfile(), other.getProfile())) {
            return false;
        }
        return Arrays.equals(this.getIndexProfile(), other.getIndexProfile());
    }

    protected boolean canEqual(Object other) {
        return other instanceof MatrixProfile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getProfile());
        result = result * 59 + Arrays.hashCode(this.getIndexProfile());
        return result;
    }

    public String toString() {
        return "MatrixProfile(profile=" + Arrays.toString(this.getProfile()) + ", indexProfile=" + Arrays.toString(this.getIndexProfile()) + ")";
    }
}

