/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation.mp;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import ro.hasna.ts.math.stat.BothWaySummaryStatistics;

public abstract class AbstractMatrixProfileTransformer
implements Serializable {
    private static final long serialVersionUID = -4758909899130005950L;
    protected final int window;
    protected final double exclusionZonePercentage;
    protected final boolean useNormalization;

    public AbstractMatrixProfileTransformer(int window) {
        this(window, 0.25, true);
    }

    public AbstractMatrixProfileTransformer(int window, double exclusionZonePercentage, boolean useNormalization) {
        this.useNormalization = useNormalization;
        if (window < 1) {
            throw new NumberIsTooSmallException(window, (Number)1, true);
        }
        this.window = window;
        this.exclusionZonePercentage = exclusionZonePercentage;
    }

    protected void computeFirstNormalizedDistanceProfile(double[] a, BothWaySummaryStatistics aStatistics, double[] b, BothWaySummaryStatistics bStatistics, int skip, int nb, double[] productSums, double[] distanceProfile) {
        if ((double)this.window > Math.log(b.length)) {
            this.computeFirstNormalizedDistanceProfileWithFft(a, aStatistics, b, bStatistics, skip, nb, productSums, distanceProfile);
        } else {
            this.computeFirstNormalizedDistanceProfileWithProductSums(a, aStatistics, b, bStatistics, skip, nb, productSums, distanceProfile);
        }
    }

    private void computeFirstNormalizedDistanceProfileWithFft(double[] a, BothWaySummaryStatistics aStatistics, double[] b, BothWaySummaryStatistics bStatistics, int skip, int nb, double[] productSums, double[] distanceProfile) {
        Complex[] transform = this.computeConvolutionUsingFft(a, 0, b);
        for (int j = skip; j < nb; ++j) {
            if (j > skip) {
                bStatistics.addValue(b[j + this.window - 1]);
                bStatistics.removeValue(b[j - 1]);
            }
            productSums[j] = transform[j + this.window - 1].getReal();
            distanceProfile[j] = this.computeNormalizedDistance(productSums[j], aStatistics, bStatistics);
        }
    }

    protected Complex[] computeConvolutionUsingFft(double[] a, int indexA, double[] b) {
        FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
        int powerOfTwo = Integer.highestOneBit(b.length);
        double[] paddedB = b;
        if (b.length > powerOfTwo) {
            paddedB = new double[powerOfTwo <<= 1];
            System.arraycopy(b, 0, paddedB, 0, b.length);
        }
        Complex[] transformB = fft.transform(paddedB, TransformType.FORWARD);
        double[] reverseA = new double[transformB.length];
        for (int i = 0; i < this.window; ++i) {
            reverseA[i] = a[indexA + this.window - 1 - i];
        }
        Complex[] transformA = fft.transform(reverseA, TransformType.FORWARD);
        for (int i = 0; i < transformB.length; ++i) {
            transformA[i] = transformA[i].multiply(transformB[i]);
        }
        return fft.transform(transformA, TransformType.INVERSE);
    }

    private void computeFirstNormalizedDistanceProfileWithProductSums(double[] a, BothWaySummaryStatistics first, double[] b, BothWaySummaryStatistics second, int skip, int nb, double[] productSums, double[] distanceProfile) {
        for (int j = skip; j < nb; ++j) {
            if (j > skip) {
                second.addValue(b[j + this.window - 1]);
                second.removeValue(b[j - 1]);
            }
            double productSum = 0.0;
            for (int k = 0; k < this.window; ++k) {
                productSum += a[k] * b[k + j];
            }
            productSums[j] = productSum;
            distanceProfile[j] = this.computeNormalizedDistance(productSums[j], first, second);
        }
    }

    protected double computeNormalizedDistance(double productSum, BothWaySummaryStatistics first, BothWaySummaryStatistics second) {
        return 2.0 * (double)this.window * (1.0 - (productSum - (double)this.window * first.getMean() * second.getMean()) / ((double)this.window * first.getStandardDeviation() * second.getStandardDeviation()));
    }

    protected void computeFirstDistanceProfileWithProductSums(double[] a, double[] b, int skip, int nb, double[] distanceProfile) {
        for (int j = skip; j < nb; ++j) {
            double distance = 0.0;
            for (int k = 0; k < this.window; ++k) {
                distance += (a[k] - b[k + j]) * (a[k] - b[k + j]);
            }
            distanceProfile[j] = distance;
        }
    }

    protected boolean inExclusionZone(int indexA, int indexB, int skip) {
        return Math.abs(indexA - indexB) < skip;
    }

    protected int[] generateRandomIndices(int n) {
        int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < n; ++i) {
            int k = ((Random)random).nextInt(n);
            int aux = indices[i];
            indices[i] = indices[k];
            indices[k] = aux;
        }
        return indices;
    }
}

