/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.distribution;

import ro.hasna.ts.math.distribution.DistributionDivider;
import ro.hasna.ts.math.distribution.NormalDistributionDivider;

public class AdaptiveDistributionDivider
implements DistributionDivider {
    private static final long serialVersionUID = -4952292138370739914L;
    private final double[][] trainingSet;
    private final DistributionDivider baseDivider;
    private final double threshold;

    public AdaptiveDistributionDivider(double[][] trainingSet, double threshold) {
        this(trainingSet, threshold, new NormalDistributionDivider());
    }

    public AdaptiveDistributionDivider(double[][] trainingSet, double threshold, DistributionDivider baseDivider) {
        this.trainingSet = trainingSet;
        this.threshold = threshold;
        this.baseDivider = baseDivider;
    }

    @Override
    public double[] getBreakpoints(int areas) {
        double[] breakpoints = this.baseDivider.getBreakpoints(areas);
        boolean stop = false;
        double oldDelta = Double.MAX_VALUE;
        double[] sum = new double[breakpoints.length + 1];
        int[] count = new int[breakpoints.length + 1];
        double[] r = new double[breakpoints.length + 1];
        while (!stop) {
            int i;
            for (int i2 = 0; i2 < breakpoints.length + 1; ++i2) {
                sum[i2] = 0.0;
                count[i2] = 0;
            }
            double[][] i2 = this.trainingSet;
            int n = i2.length;
            for (int j = 0; j < n; ++j) {
                double[] row;
                for (double v : row = i2[j]) {
                    boolean found = false;
                    for (int k = 0; k < breakpoints.length && !found; ++k) {
                        double breakpoint = breakpoints[k];
                        if (!(breakpoint > v)) continue;
                        int n2 = k;
                        sum[n2] = sum[n2] + v;
                        int n3 = k;
                        count[n3] = count[n3] + 1;
                        found = true;
                    }
                    if (found) continue;
                    int n4 = breakpoints.length;
                    sum[n4] = sum[n4] + v;
                    int n5 = breakpoints.length;
                    count[n5] = count[n5] + 1;
                }
            }
            for (i = 0; i < breakpoints.length + 1; ++i) {
                r[i] = sum[i] / (double)count[i];
            }
            for (i = 0; i < breakpoints.length; ++i) {
                breakpoints[i] = (r[i] + r[i + 1]) / 2.0;
            }
            double delta = 0.0;
            double[][] dArray = this.trainingSet;
            int n6 = dArray.length;
            for (int j = 0; j < n6; ++j) {
                double[] row;
                for (double v : row = dArray[j]) {
                    boolean found = false;
                    for (int k = 0; k < breakpoints.length && !found; ++k) {
                        double breakpoint = breakpoints[k];
                        if (!(breakpoint > v)) continue;
                        double aux = v - r[k];
                        delta += aux * aux;
                        found = true;
                    }
                    if (found) continue;
                    double aux = v - r[breakpoints.length];
                    delta += aux * aux;
                }
            }
            if ((oldDelta - delta) / oldDelta >= this.threshold) {
                oldDelta = delta;
                continue;
            }
            stop = true;
        }
        return breakpoints;
    }
}

