/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.State;
import java.time.Instant;
import java.util.Objects;

public class Shot {
    public final String signal;
    public final Instant ts;
    public final State state;

    public Shot(Instant ts, State state, String signal) {
        this.ts = ts;
        this.state = state;
        this.signal = signal;
    }

    public static Shot on(long seconds, String signal) {
        return Shot.on(Instant.ofEpochSecond(seconds), signal);
    }

    public static Shot off(long seconds, String signal) {
        return Shot.off(Instant.ofEpochSecond(seconds), signal);
    }

    public static Shot on(Instant instant, String signal) {
        return new Shot(instant, State.On, signal);
    }

    public static Shot off(Instant instant, String signal) {
        return new Shot(instant, State.Off, signal);
    }

    public String toString() {
        return String.join((CharSequence)" ", this.ts.toString(), this.signal, this.state.name());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this == o || this.equals((Shot)o);
    }

    private boolean equals(Shot shot) {
        return Objects.equals(this.signal, shot.signal) && Objects.equals(this.ts, shot.ts) && this.state == shot.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signal, this.ts, this.state});
    }
}

