/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.model;

import io.intino.ness.master.Datamart;
import io.intino.ness.master.model.Entity;
import io.intino.ness.master.model.Struct;
import io.intino.ness.master.reflection.AttributeDefinition;
import io.intino.ness.master.reflection.ConceptDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public sealed interface Concept
permits Entity, Struct {
    public Datamart datamart();

    public Attribute attribute(String var1);

    public List<Attribute> attributes();

    public void addChangeListener(ChangeListener var1);

    public ConceptDefinition<?> getDefinition();

    default public boolean instanceOf(ConceptDefinition definition) {
        ConceptDefinition<?> myDefinition = this.getDefinition();
        return myDefinition.equals(definition) || myDefinition.isDescendantOf(definition);
    }

    @FunctionalInterface
    public static interface ChangeListener {
        public void onChange(Concept var1, Attribute var2, Attribute.Value var3);
    }

    public static interface Attribute {
        default public String name() {
            return this.getDefinition().name();
        }

        default public Class<?> type() {
            return this.getDefinition().type();
        }

        public Value value();

        public void addChangeListener(ChangeListener var1);

        public AttributeDefinition getDefinition();

        @FunctionalInterface
        public static interface ChangeListener {
            public void onValueChange(Value var1, Value var2);
        }

        public static class Value {
            private final Object value;
            private static final Map<Class<?>, Function<String, Object>> StringParsers = new HashMap<Class<?>, Function<String, Object>>(){
                {
                    this.put(Byte.TYPE, Byte::parseByte);
                    this.put(Short.TYPE, Short::parseShort);
                    this.put(Integer.TYPE, Integer::parseInt);
                    this.put(Long.TYPE, Long::parseLong);
                    this.put(Float.TYPE, Float::parseFloat);
                    this.put(Double.TYPE, Double::parseDouble);
                    this.put(Boolean.TYPE, Boolean::parseBoolean);
                    this.put(Byte.class, Byte::parseByte);
                    this.put(Short.class, Short::parseShort);
                    this.put(Integer.class, Integer::parseInt);
                    this.put(Long.class, Long::parseLong);
                    this.put(Float.class, Float::parseFloat);
                    this.put(Double.class, Double::parseDouble);
                    this.put(Boolean.class, Boolean::parseBoolean);
                }
            };

            public Value(Object value) {
                this.value = value;
            }

            public Object get() {
                return this.value;
            }

            public <T> T as(Class<T> type) {
                if (this.value == null) {
                    return null;
                }
                if (this.value.getClass() == String.class && StringParsers.containsKey(type)) {
                    return (T)StringParsers.get(type).apply(this.value.toString());
                }
                return (T)this.value;
            }

            public <T> T as() {
                return (T)this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return Objects.equals(this.value, ((Value)o).value);
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }

            public String toString() {
                return String.valueOf(this.get());
            }
        }
    }
}

