/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.measurements.monitoring;

import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;

public class Computer
extends MeasurementEvent
implements Serializable {
    private static final String[] declaredMagnitudes = new String[]{"usage.RAM;" + String.join((CharSequence)";", "unit=MB", "format=%,.2f", "operator=avg", "tail=UP", "distribution=Normal"), "usage.HDD;" + String.join((CharSequence)";", "unit=MB", "format=%,.2f", "operator=avg", "tail=UP", "distribution=Normal"), "usage.CPU;" + String.join((CharSequence)";", "unit=%", "format=%,.2f", "operator=avg", "tail=UP", "distribution=Normal"), "usage.system;" + String.join((CharSequence)";", "format=%,.2f", "operator=avg", "tail=UP", "distribution=Normal"), "usage.threads;" + String.join((CharSequence)";", "format=%d", "operator=last", "tail=UP", "distribution=Normal"), "usage.files;" + String.join((CharSequence)";", "format=%d", "operator=avg", "tail=UP", "distribution=Normal"), "temperature.kernel;" + String.join((CharSequence)";", "unit=\u00baC", "format=%,.0f", "operator=avg", "tail=UP", "distribution=Normal"), "temperature.external;" + String.join((CharSequence)";", "unit=\u00baC", "format=%,.0f", "operator=avg", "tail=UP", "distribution=Normal"), "data.received;" + String.join((CharSequence)";", "unit=MB", "format=%,.0f", "operator=sum", "tail=UP"), "data.sent;" + String.join((CharSequence)";", "unit=MB", "format=%,.0f", "operator=sum", "tail=UP"), "applications.system;" + String.join((CharSequence)";", "format=%d", "operator=last", "tail=UP", "distribution=Normal"), "applications.known;" + String.join((CharSequence)";", "format=%d", "operator=last", "tail=UP"), "applications.unknown;" + String.join((CharSequence)";", "format=%d", "operator=last", "tail=UP")};

    public Computer(String ss) {
        super("Computer", ss, Instant.now(), declaredMagnitudes, new double[13]);
    }

    public Computer(String ss, String sensor) {
        super("Computer", ss + "?sensor=" + sensor, Instant.now(), declaredMagnitudes, new double[13]);
    }

    public Computer(String ss, String sensor, Instant ts) {
        super("Computer", ss + "?sensor=" + sensor, ts, declaredMagnitudes, new double[13]);
    }

    public Computer(MeasurementEvent event) {
        super("Computer", event.ss(), event.ts(), event.magnitudes(), event.values());
    }

    public Computer(Message message) {
        super("Computer", message.get("ss").asString(), message.get("ts").asInstant(), message.get("magnitudes").as(String[].class), Arrays.stream(message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray());
    }

    public double usageRAM() {
        return this.values[0];
    }

    public double usageHDD() {
        return this.values[1];
    }

    public double usageCPU() {
        return this.values[2];
    }

    public double usageSystem() {
        return this.values[3];
    }

    public double usageThreads() {
        return this.values[4];
    }

    public double usageFiles() {
        return this.values[5];
    }

    public double temperatureKernel() {
        return this.values[6];
    }

    public double temperatureExternal() {
        return this.values[7];
    }

    public double dataReceived() {
        return this.values[8];
    }

    public double dataSent() {
        return this.values[9];
    }

    public double applicationsSystem() {
        return this.values[10];
    }

    public double applicationsKnown() {
        return this.values[11];
    }

    public double applicationsUnknown() {
        return this.values[12];
    }

    public Computer usageRAM(double value) {
        this.values[0] = value;
        return this;
    }

    public Computer usageHDD(double value) {
        this.values[1] = value;
        return this;
    }

    public Computer usageCPU(double value) {
        this.values[2] = value;
        return this;
    }

    public Computer usageSystem(double value) {
        this.values[3] = value;
        return this;
    }

    public Computer usageThreads(double value) {
        this.values[4] = value;
        return this;
    }

    public Computer usageFiles(double value) {
        this.values[5] = value;
        return this;
    }

    public Computer temperatureKernel(double value) {
        this.values[6] = value;
        return this;
    }

    public Computer temperatureExternal(double value) {
        this.values[7] = value;
        return this;
    }

    public Computer dataReceived(double value) {
        this.values[8] = value;
        return this;
    }

    public Computer dataSent(double value) {
        this.values[9] = value;
        return this;
    }

    public Computer applicationsSystem(double value) {
        this.values[10] = value;
        return this;
    }

    public Computer applicationsKnown(double value) {
        this.values[11] = value;
        return this;
    }

    public Computer applicationsUnknown(double value) {
        this.values[12] = value;
        return this;
    }

    public MessageEvent toMessageEvent() {
        Message message = new Message(this.getClass().getSimpleName());
        message.set("ts", this.ts);
        message.set("ss", this.source);
        Arrays.stream(this.magnitudes).forEach(m -> message.append("magnitudes", m.toString()));
        Arrays.stream(this.values).forEach(m -> message.append("values", m));
        return new MessageEvent(message);
    }
}

