/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zim;

import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageWriter;
import io.intino.alexandria.resourcecleaner.DisposableResource;
import io.intino.alexandria.zim.Zim;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

public class ZimWriter
implements AutoCloseable {
    private final MessageWriter writer;
    private final DisposableResource resource;

    public ZimWriter(File file) throws IOException {
        this(Zim.compressing(new BufferedOutputStream(new FileOutputStream(file))));
    }

    public ZimWriter(OutputStream out) throws IOException {
        MessageWriter writer;
        this.writer = writer = new MessageWriter(Zim.compressing(out));
        this.resource = DisposableResource.whenDestroyed(this).thenClose(writer);
    }

    public void write(Message ... messages) throws IOException {
        this.write(Arrays.stream(messages));
    }

    public void write(Collection<Message> messages) throws IOException {
        this.write(messages.stream());
    }

    public void write(Stream<Message> messages) throws IOException {
        Iterator iterator = messages.iterator();
        while (iterator.hasNext()) {
            this.write((Message)iterator.next());
        }
    }

    public void write(Message message) throws IOException {
        this.writer.write(message);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.resource.close();
    }
}

