/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.resource;

import io.intino.alexandria.Resource;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import java.io.File;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;

public class ResourceEvent
implements Event {
    public static final String METADATA = ".metadata";
    static final String ENTRY_NAME_SEP = "$";
    private final String type;
    private final String ss;
    private Instant ts = Instant.now();
    private final Resource resource;

    public ResourceEvent(String type, String ss, Resource resource) {
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.ss = Objects.requireNonNull(ss, "ss cannot be null");
        this.resource = Objects.requireNonNull(resource, "resource cannot be null");
        if (resource.name().isBlank()) {
            throw new IllegalArgumentException("Resource name cannot be blank");
        }
    }

    public ResourceEvent(String type, String ss, File file) {
        this(type, ss, new Resource(file));
    }

    public Resource resource() {
        return this.resource;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public Instant ts() {
        return this.ts;
    }

    public REI getREI() {
        return new REI(this.type, this.ss, this.ts, this.resource.name());
    }

    public ResourceEvent ts(Instant ts) {
        this.ts = Objects.requireNonNull(ts, "ts cannot be null");
        return this;
    }

    @Override
    public String ss() {
        return this.ss;
    }

    @Override
    public Event.Format format() {
        return Event.Format.Resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceEvent that = (ResourceEvent)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.ss, that.ss) && Objects.equals(this.ts, that.ts);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.ss, this.ts);
    }

    public String toString() {
        Message message = new Message(this.getClass().getSimpleName());
        message.set("ss", this.ss());
        message.set("ts", this.ts());
        message.set("resource", this.resource().name());
        message.set("REI", this.getREI().toString());
        return message.toString();
    }

    public static ResourceEvent of(Resource resource) {
        Resource.Metadata metadata = resource.metadata();
        String type = metadata.getProperty("$type").orElseThrow(() -> new MissingResourceMetadataException("Resource '" + resource.name() + "' does not declare the type in its metadata."));
        String ss = metadata.getProperty("$ss").orElseThrow(() -> new MissingResourceMetadataException("Resource '" + resource.name() + "' does not declare the ss in its metadata."));
        String ts = metadata.getProperty("$ts").orElseThrow(() -> new MissingResourceMetadataException("Resource '" + resource.name() + "' does not declare the ts in its metadata."));
        return new ResourceEvent(type, ss, resource).ts(Instant.parse(ts));
    }

    public static class REI {
        public static final String SEP = "/";
        public static final String ID_SEP = "#";
        public static final String NAME_SEP = "$";
        public static final int SIZE = 4;
        private final String[] components;

        public static REI of(String rei) {
            try {
                return REI.of(rei.split(SEP, 4));
            }
            catch (Exception e) {
                return REI.of(rei.split(ID_SEP, 4));
            }
        }

        public static REI of(String[] components) {
            if (components.length != 4) {
                throw new MalformedREIException("REI must have 4 components: type, ss, ts and resource name");
            }
            if (components[0] == null || components[0].isBlank()) {
                throw new MalformedREIException("type in REI cannot be null nor blank");
            }
            if (components[1] == null || components[1].isBlank()) {
                throw new MalformedREIException("ss in REI cannot be null nor blank");
            }
            if (components[2] == null || components[2].isBlank() || REI.isNotAValidTs(components[2])) {
                throw new MalformedREIException("ts in REI is not a valid ts");
            }
            if (components[3] == null || components[3].isBlank()) {
                throw new MalformedREIException("resource name in REI cannot be null nor blank");
            }
            return new REI(components);
        }

        private REI(String[] components) {
            this.components = components;
        }

        public REI(String type, String ss, Instant ts, String resourceName) {
            this.components = new String[]{type, ss, String.valueOf(ts.toEpochMilli()), resourceName};
        }

        public String type() {
            return this.components[0];
        }

        public String ss() {
            return this.components[1];
        }

        public Instant ts() {
            return Instant.ofEpochMilli(Long.parseLong(this.components[2]));
        }

        public String tsRaw() {
            return this.components[2];
        }

        public String resourceName() {
            return this.components[3];
        }

        public String resourceId() {
            return this.tsRaw() + ID_SEP + this.resourceName().replace(SEP, "$");
        }

        private static boolean isNotAValidTs(String ts) {
            try {
                Instant.ofEpochMilli(Long.parseLong(ts));
                return false;
            }
            catch (Exception ignored) {
                return true;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            REI rei = (REI)o;
            return Arrays.equals(this.components, rei.components);
        }

        public int hashCode() {
            return Arrays.hashCode(this.components);
        }

        public String toString() {
            return String.join((CharSequence)SEP, this.components);
        }
    }

    public static class MissingResourceMetadataException
    extends RuntimeException {
        public MissingResourceMetadataException(String message) {
            super(message);
        }
    }

    public static class MalformedREIException
    extends RuntimeException {
        public MalformedREIException(String message) {
            super(message);
        }
    }
}

