/*
 * Decompiled with CFR 0.152.
 */
package smile.timeseries;

import smile.math.special.Gamma;
import smile.timeseries.TimeSeries;

public class BoxTest {
    public final Type type;
    public final int df;
    public final double q;
    public final double pvalue;

    private BoxTest(Type type, double q, int df, double pvalue) {
        this.type = type;
        this.q = q;
        this.df = df;
        this.pvalue = pvalue;
    }

    public String toString() {
        return String.format("%s test(q = %.4f, df = %d, p-value = %G)", new Object[]{this.type, this.q, this.df, this.pvalue});
    }

    public static BoxTest pierce(double[] x, int lag) {
        double q = 0.0;
        for (int l = 1; l <= lag; ++l) {
            double r = TimeSeries.acf(x, l);
            q += r * r;
        }
        double p = Gamma.regularizedUpperIncompleteGamma(0.5 * (double)lag, 0.5 * (q *= (double)x.length));
        return new BoxTest(Type.Box_Pierce, q, lag, p);
    }

    public static BoxTest ljung(double[] x, int lag) {
        int n = x.length;
        double q = 0.0;
        for (int l = 1; l <= lag; ++l) {
            double r = TimeSeries.acf(x, l);
            q += r * r / (double)(n - l);
        }
        double p = Gamma.regularizedUpperIncompleteGamma(0.5 * (double)lag, 0.5 * (q *= (double)(n * (n + 2))));
        return new BoxTest(Type.Ljung_Box, q, lag, p);
    }

    public static enum Type {
        Box_Pierce{

            public String toString() {
                return "Box-Pierce";
            }
        }
        ,
        Ljung_Box{

            public String toString() {
                return "Ljung-Box";
            }
        };

    }
}

