/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.kernel.IsotropicKernel;

public class Gaussian
implements IsotropicKernel {
    private static final long serialVersionUID = 2L;
    final double sigma;
    final double lo;
    final double hi;

    public Gaussian(double sigma, double lo, double hi) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive: " + sigma);
        }
        this.sigma = sigma;
        this.lo = lo;
        this.hi = hi;
    }

    public double scale() {
        return this.sigma;
    }

    public String toString() {
        return String.format("GaussianKernel(%.4f)", this.sigma);
    }

    @Override
    public double k(double dist) {
        double d = dist / this.sigma;
        return Math.exp(-0.5 * d * d);
    }

    @Override
    public double[] kg(double dist) {
        double k;
        double[] g = new double[2];
        double d = dist / this.sigma;
        g[0] = k = Math.exp(-0.5 * d * d);
        g[1] = k * d * d / this.sigma;
        return g;
    }
}

