/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.extraction;

import java.util.Arrays;
import java.util.function.Function;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.measure.CategoricalMeasure;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class BinaryEncoder
implements Function<Tuple, int[]> {
    private final StructType schema;
    private final String[] columns;
    private final int[] base;

    public BinaryEncoder(StructType schema, String ... columns) {
        this.schema = schema;
        if (columns == null || columns.length == 0) {
            columns = (String[])Arrays.stream(schema.fields()).filter(field -> field.measure instanceof CategoricalMeasure).map(field -> field.name).toArray(String[]::new);
        }
        this.columns = columns;
        this.base = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            StructField field2 = schema.field(columns[i]);
            if (!(field2.measure instanceof CategoricalMeasure)) {
                throw new IllegalArgumentException("Non-categorical attribute: " + field2);
            }
            if (i >= this.base.length - 1) continue;
            this.base[i + 1] = this.base[i] + ((CategoricalMeasure)field2.measure).size();
        }
    }

    @Override
    public int[] apply(Tuple x) {
        int[] features = new int[this.columns.length];
        for (int i = 0; i < features.length; ++i) {
            features[i] = x.getInt(this.columns[i]) + this.base[i];
        }
        return features;
    }

    @Override
    public int[][] apply(DataFrame data) {
        return (int[][])data.stream().map(this::apply).toArray(x$0 -> new int[x$0][]);
    }
}

