/*
 * Decompiled with CFR 0.152.
 */
package smile.base.mlp;

import java.io.IOException;
import java.io.ObjectInputStream;
import smile.base.mlp.Layer;

public class InputLayer
extends Layer {
    private static final long serialVersionUID = 2L;

    public InputLayer(int p) {
        this(p, 0.0);
    }

    public InputLayer(int p, double dropout) {
        super(p, dropout);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.output = ThreadLocal.withInitial(() -> new double[this.n]);
        if (this.dropout > 0.0) {
            this.mask = ThreadLocal.withInitial(() -> new byte[this.n]);
        }
    }

    public String toString() {
        if (this.dropout > 0.0) {
            return String.format("Input(%d, %.2f)", this.n, this.dropout);
        }
        return String.format("Input(%d)", this.n);
    }

    @Override
    public void propagate(double[] x) {
        System.arraycopy(x, 0, this.output.get(), 0, this.p);
    }

    @Override
    public void backpropagate(double[] lowerLayerGradient) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transform(double[] x) {
    }

    @Override
    public void computeGradient(double[] x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void computeGradientUpdate(double[] x, double learningRate, double momentum, double decay) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(int m, double learningRate, double momentum, double decay, double rho, double epsilon) {
        throw new UnsupportedOperationException();
    }
}

