/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation.mp;

import org.apache.commons.math3.util.FastMath;
import ro.hasna.ts.math.exception.ArrayLengthIsTooSmallException;
import ro.hasna.ts.math.representation.mp.AbstractMatrixProfileTransformer;
import ro.hasna.ts.math.stat.BothWaySummaryStatistics;
import ro.hasna.ts.math.type.FullMatrixProfile;
import ro.hasna.ts.math.type.MatrixProfile;

public class MatrixProfileTransformer
extends AbstractMatrixProfileTransformer {
    private static final long serialVersionUID = 1675705026272406220L;

    public MatrixProfileTransformer(int window) {
        super(window, 0.0, true);
    }

    public MatrixProfileTransformer(int window, double exclusionZonePercentage, boolean useNormalization) {
        super(window, exclusionZonePercentage, useNormalization);
    }

    public MatrixProfile transform(double[] a, double[] b) {
        int skip = (int)((double)this.window * this.exclusionZonePercentage);
        if (Math.min(a.length, b.length) < this.window + skip) {
            throw new ArrayLengthIsTooSmallException(Math.min(a.length, b.length), (Number)(this.window + skip), true);
        }
        if (this.useNormalization) {
            return this.computeNormalizedFullMatrixProfile(a, b, skip).getLeftMatrixProfile();
        }
        return this.computeFullMatrixProfile(a, b, skip).getLeftMatrixProfile();
    }

    public FullMatrixProfile fullJoinTransform(double[] a, double[] b) {
        int skip = (int)((double)this.window * this.exclusionZonePercentage);
        if (Math.min(a.length, b.length) < this.window + skip) {
            throw new ArrayLengthIsTooSmallException(Math.min(a.length, b.length), (Number)(this.window + skip), true);
        }
        if (this.useNormalization) {
            return this.computeNormalizedFullMatrixProfile(a, b, skip);
        }
        return this.computeFullMatrixProfile(a, b, skip);
    }

    private FullMatrixProfile computeNormalizedFullMatrixProfile(double[] a, double[] b, int skip) {
        int i;
        int na = a.length - this.window + 1;
        int nb = b.length - this.window + 1;
        FullMatrixProfile fmp = new FullMatrixProfile(nb, na);
        double[] distanceProfile = new double[nb];
        double[] productSums = new double[nb];
        BothWaySummaryStatistics first = new BothWaySummaryStatistics();
        BothWaySummaryStatistics second = new BothWaySummaryStatistics();
        for (i = 0; i < this.window; ++i) {
            first.addValue(a[i]);
            second.addValue(b[i + skip]);
        }
        this.computeFirstNormalizedDistanceProfile(a, first, b, second, skip, nb, productSums, distanceProfile);
        this.updateMatrixProfileFromDistanceProfile(distanceProfile, 0, skip, nb, fmp);
        for (i = 1; i < na; ++i) {
            this.computeNextNormalizedDistanceProfile(a, first, i, b, second, skip, nb, distanceProfile, productSums);
            this.updateMatrixProfileFromDistanceProfile(distanceProfile, i, skip, nb, fmp);
        }
        this.sqrtMatrixProfile(fmp);
        return fmp;
    }

    private void computeNextNormalizedDistanceProfile(double[] a, BothWaySummaryStatistics first, int i, double[] b, BothWaySummaryStatistics second, int skip, int nb, double[] distanceProfile, double[] productSums) {
        first.removeValue(a[i - 1]);
        first.addValue(a[i + this.window - 1]);
        BothWaySummaryStatistics secondClone = second.clone();
        for (int j = nb - 1; j >= 1; --j) {
            if (j < nb - 1) {
                secondClone.removeValue(b[j + this.window]);
                secondClone.addValue(b[j]);
            }
            double prev = a[i - 1] * b[j - 1];
            double next = a[i + this.window - 1] * b[j + this.window - 1];
            productSums[j] = productSums[j - 1] - prev + next;
            distanceProfile[j] = this.computeNormalizedDistance(productSums[j], first, secondClone);
        }
        secondClone.removeValue(b[this.window]);
        secondClone.addValue(b[0]);
        double productSum = 0.0;
        for (int k = 0; k < this.window; ++k) {
            productSum += a[k + i] * b[k];
        }
        productSums[0] = productSum;
        distanceProfile[0] = this.computeNormalizedDistance(productSums[0], first, secondClone);
    }

    private FullMatrixProfile computeFullMatrixProfile(double[] a, double[] b, int skip) {
        int na = a.length - this.window + 1;
        int nb = b.length - this.window + 1;
        FullMatrixProfile fmp = new FullMatrixProfile(nb, na);
        double[] distanceProfile = new double[nb];
        this.computeFirstDistanceProfileWithProductSums(a, b, skip, nb, distanceProfile);
        this.updateMatrixProfileFromDistanceProfile(distanceProfile, 0, skip, nb, fmp);
        for (int i = 1; i < na; ++i) {
            this.computeNextDistanceProfile(a, b, nb, distanceProfile, i);
            this.updateMatrixProfileFromDistanceProfile(distanceProfile, i, skip, nb, fmp);
        }
        this.sqrtMatrixProfile(fmp);
        return fmp;
    }

    private void computeNextDistanceProfile(double[] a, double[] b, int nb, double[] prevDistanceProfile, int i) {
        for (int j = nb - 1; j >= 1; --j) {
            double prev = a[i - 1] - b[j - 1];
            double next = a[i + this.window - 1] - b[j + this.window - 1];
            prevDistanceProfile[j] = prevDistanceProfile[j - 1] - prev * prev + next * next;
        }
        double distance = 0.0;
        for (int k = 0; k < this.window; ++k) {
            distance += (a[k + i] - b[k]) * (a[k + i] - b[k]);
        }
        prevDistanceProfile[0] = distance;
    }

    private void updateMatrixProfileFromDistanceProfile(double[] distanceProfile, int i, int skip, int nb, FullMatrixProfile mp) {
        double[] leftProfile = mp.getLeftMatrixProfile().getProfile();
        int[] leftIndexProfile = mp.getLeftMatrixProfile().getIndexProfile();
        double[] rightProfile = mp.getRightMatrixProfile().getProfile();
        int[] rightIndexProfile = mp.getRightMatrixProfile().getIndexProfile();
        for (int j = 0; j < nb; ++j) {
            if (this.inExclusionZone(i, j, skip)) continue;
            if (leftProfile[j] > distanceProfile[j]) {
                leftProfile[j] = distanceProfile[j];
                leftIndexProfile[j] = i;
            }
            if (!(rightProfile[i] > distanceProfile[j])) continue;
            rightProfile[i] = distanceProfile[j];
            rightIndexProfile[i] = j;
        }
    }

    private void sqrtMatrixProfile(FullMatrixProfile fmp) {
        double[] leftProfile = fmp.getLeftMatrixProfile().getProfile();
        for (int i = 0; i < leftProfile.length; ++i) {
            leftProfile[i] = FastMath.sqrt(leftProfile[i]);
        }
        double[] rightProfile = fmp.getRightMatrixProfile().getProfile();
        for (int i = 0; i < rightProfile.length; ++i) {
            rightProfile[i] = FastMath.sqrt(rightProfile[i]);
        }
    }
}

