/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.MeasurementsVector;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Timeline;
import io.intino.sumus.chronos.TimelineImpl;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.itl.ItlReader;
import io.intino.sumus.chronos.timelines.TimelineReader;
import io.intino.sumus.chronos.timelines.writers.FileTimelineWriter;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Timelines {
    public static TimelineStore append(String sensor, File file, Instant instant, Period period, MeasurementsVector measurements) throws IOException {
        try (FileTimelineWriter writer = new FileTimelineWriter(sensor, file, true);){
            writer.sensorModel(measurements.sensorModel());
            writer.timeModel(instant, period);
            writer.set(measurements.toArray());
        }
        return TimelineStore.of(file);
    }

    public static Timeline readItl(File file) throws IOException {
        return ItlReader.read(file);
    }

    public static Timeline readItl(List<String> lines) {
        return ItlReader.read(lines);
    }

    public static Timeline readItl(String[] lines) {
        return ItlReader.read(Arrays.stream(lines).collect(Collectors.toList()));
    }

    public static Timeline read(File file) throws IOException {
        return Timelines.read(FileChannel.open(file.toPath(), StandardOpenOption.READ));
    }

    public static Timeline read(ReadableByteChannel channel) {
        Timeline timeline;
        TimelineReader reader = new TimelineReader(channel);
        try {
            TimelineImpl.Builder builder = new TimelineImpl.Builder((int)reader.header().recordCount());
            while (reader.hasNext()) {
                TimelineStore.Block block = reader.next();
                if (block.mark() != 21845) continue;
                builder.set(reader.sensorModel(), (TimelineStore.Data)block);
            }
            timeline = builder.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return timeline;
    }
}

