/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.actuation;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Rollout
extends MessageEvent
implements Serializable {
    public Rollout(String ss) {
        this(new MessageEvent("Rollout", ss).toMessage());
    }

    public Rollout(MessageEvent event) {
        this(event.toMessage());
    }

    public Rollout(Message message) {
        super(message);
    }

    private Rollout(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public Rollout ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public Rollout ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static Rollout fromString(String event) {
        return new Rollout(new MessageReader(event).next());
    }

    public String id() {
        return !this.message.contains("id") ? null : this.message.get("id").asString();
    }

    public State state() {
        return !this.message.contains("state") ? null : State.valueOf(this.message.get("state").asString());
    }

    public String orderCode() {
        return !this.message.contains("orderCode") ? null : this.message.get("orderCode").asString();
    }

    public String hint() {
        return !this.message.contains("hint") ? null : this.message.get("hint").asString();
    }

    public String startDate() {
        return !this.message.contains("startDate") ? null : this.message.get("startDate").asString();
    }

    public String dueDate() {
        return !this.message.contains("dueDate") ? null : this.message.get("dueDate").asString();
    }

    public String notification() {
        return !this.message.contains("notification") ? null : this.message.get("notification").asString();
    }

    public List<String> conditions() {
        String[] array = this.message.get("conditions").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                Rollout.this.message.append("conditions", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                Rollout.this.message.remove("conditions", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                Rollout.this.message.remove("conditions");
            }
        };
    }

    public Rollout id(String id) {
        if (id == null) {
            this.message.remove("id");
        } else {
            this.message.set("id", id);
        }
        return this;
    }

    public Rollout state(State state) {
        if (state == null) {
            this.message.remove("state");
        } else {
            this.message.set("state", state.name());
        }
        return this;
    }

    public Rollout orderCode(String orderCode) {
        if (orderCode == null) {
            this.message.remove("orderCode");
        } else {
            this.message.set("orderCode", orderCode);
        }
        return this;
    }

    public Rollout hint(String hint) {
        if (hint == null) {
            this.message.remove("hint");
        } else {
            this.message.set("hint", hint);
        }
        return this;
    }

    public Rollout startDate(String startDate) {
        if (startDate == null) {
            this.message.remove("startDate");
        } else {
            this.message.set("startDate", startDate);
        }
        return this;
    }

    public Rollout dueDate(String dueDate) {
        if (dueDate == null) {
            this.message.remove("dueDate");
        } else {
            this.message.set("dueDate", dueDate);
        }
        return this;
    }

    public Rollout notification(String notification) {
        if (notification == null) {
            this.message.remove("notification");
        } else {
            this.message.set("notification", notification);
        }
        return this;
    }

    public Rollout conditions(List<String> conditions) {
        this.message.set("conditions", conditions);
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static enum State {
        Open,
        Aborted,
        Terminated;

    }
}

