/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import io.intino.cosmos.datahub.datamarts.master.mounters.ApplicationMounter;
import io.intino.ness.master.Datamart;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApplicationMounter
implements MasterMounter {
    private final MasterDatamart.Entities entities;
    private final List<Datamart.EntityListener> listeners;
    private boolean useListeners = true;
    private static final DateTimeFormatter StartingTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");

    public ApplicationMounter(MasterDatamart.Entities entities, List<Datamart.EntityListener> listeners) {
        this.entities = entities;
        this.listeners = listeners;
    }

    @Override
    public ApplicationMounter useListeners(boolean useListeners) {
        this.useListeners = useListeners;
        return this;
    }

    @Override
    public void mount(Event event) {
        Message message = ((MessageEvent)event).toMessage();
        String id = message.get("id").asString();
        MasterMounter.Operation[] operation = new MasterMounter.Operation[]{MasterMounter.Operation.Update};
        MasterEntity entity = this.findOrCreateEntity(id, operation);
        this.updateAttributes(message, operation, entity);
        if (operation[0] != MasterMounter.Operation.Skip && this.useListeners) {
            this.notifyListeners(operation[0], entity);
        }
    }

    private void updateAttributes(Message message, MasterMounter.Operation[] operation, MasterEntity owner) {
        for (String attr : message.attributes()) {
            this.update(owner, attr, this.parse(attr, message));
            if (!attr.equals("enabled")) continue;
            if (message.get("enabled").asBoolean().booleanValue()) {
                this.entities.enable(owner.id());
                continue;
            }
            this.entities.disable(owner.id());
        }
        Map<String, List<Message>> components = message.components().stream().collect(Collectors.groupingBy(Message::type));
        if (components.containsKey("Operation")) {
            this.update(owner, "operationList", new Application.OperationStructFactory(this).create(components.get("Operation")));
        }
    }

    private MasterEntity findOrCreateEntity(String id, MasterMounter.Operation[] operation) {
        Object entity = this.entities.get(Application.definition, id);
        if (entity == null) {
            entity = this.entities.getDisabled(Application.definition, id);
        }
        if (entity == null) {
            entity = new Application(id, this.entities.datamart());
            this.entities.add((MasterEntity)entity);
            operation[0] = MasterMounter.Operation.Create;
        }
        return entity;
    }

    private void notifyListeners(MasterMounter.Operation operation, MasterEntity entity) {
        for (Datamart.EntityListener listener : this.listeners) {
            switch (operation) {
                case Create: {
                    new Thread(() -> listener.onCreate(entity), "MasterListener-ApplicationMounter-" + System.currentTimeMillis()).start();
                    break;
                }
                case Update: {
                    new Thread(() -> listener.onUpdate(entity), "MasterListener-ApplicationMounter-" + System.currentTimeMillis()).start();
                    break;
                }
                case Remove: {
                    new Thread(() -> listener.onRemove(entity), "MasterListener-ApplicationMounter-" + System.currentTimeMillis()).start();
                }
            }
        }
    }

    private Object parse(String attribute, Message message) {
        if (message.get(attribute).isNull()) {
            return null;
        }
        switch (attribute) {
            case "tags": {
                return this.parseTags(message);
            }
            case "responsible": {
                return this.parseResponsible(message);
            }
            case "observer": {
                return this.parseObserver(message);
            }
            case "container": {
                return this.parseContainer(message);
            }
            case "model": {
                return this.parseModel(message);
            }
            case "team": {
                return this.parseTeam(message);
            }
            case "place": {
                return this.parsePlace(message);
            }
            case "label": {
                return this.parseLabel(message);
            }
            case "name": {
                return this.parseName(message);
            }
            case "user": {
                return this.parseUser(message);
            }
            case "systemService": {
                return this.parseSystemService(message);
            }
            case "startingTime": {
                return this.parseStartingTime(message);
            }
            case "pid": {
                return this.parsePid(message);
            }
            case "commandLine": {
                return this.parseCommandLine(message);
            }
            case "state": {
                return this.parseState(message);
            }
        }
        return message.get(attribute).asString();
    }

    private List<String> parseTags(Message m) {
        Message.Value value = m.get("tags");
        return value.data().isEmpty() ? Collections.emptyList() : value.asList(String.class);
    }

    private String parseResponsible(Message m) {
        return m.get("responsible").asString();
    }

    private String parseObserver(Message m) {
        return m.get("observer").asString();
    }

    private String parseContainer(Message m) {
        return m.get("container").asString();
    }

    private String parseModel(Message m) {
        return m.get("model").asString();
    }

    private String parseTeam(Message m) {
        return m.get("team").as(String.class);
    }

    private String parsePlace(Message m) {
        return m.get("place").asString();
    }

    private String parseLabel(Message m) {
        return m.get("label").as(String.class);
    }

    private String parseName(Message m) {
        return m.get("name").as(String.class);
    }

    private String parseUser(Message m) {
        return m.get("user").as(String.class);
    }

    private String parseSystemService(Message m) {
        return m.get("systemService").as(String.class);
    }

    private LocalDateTime parseStartingTime(Message m) {
        try {
            return LocalDateTime.parse(m.get("startingTime").asString(), StartingTimeFormatter);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private Integer parsePid(Message m) {
        return m.get("pid").as(Integer.class);
    }

    private String parseCommandLine(Message m) {
        return m.get("commandLine").as(String.class);
    }

    private Application.State parseState(Message m) {
        try {
            return Application.State.valueOf(m.get("state").asString());
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

