/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.os.local;

import com.google.gson.JsonObject;
import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.os.local.LocalOperatingSystem;
import io.intino.consul.framework.Activity;
import io.intino.consul.framework.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.LocalDate;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import oshi.SystemInfo;

public class LocalSystem
implements Activity.System {
    public static final String LOOP_BACK_ADDRESS = "127.0.0.1";
    private final SystemInfo si;
    private final String ispProviderToken;
    private Map.Entry<LocalDate, JsonObject> ipInfo;

    public LocalSystem(String ispProviderToken) {
        this.ispProviderToken = ispProviderToken;
        this.si = new SystemInfo();
        LogManager.getCurrentLoggers().asIterator().forEachRemaining(c -> ((org.apache.log4j.Logger)c).setLevel(Level.ERROR));
    }

    @Override
    public String name() {
        return Utils.calculateHostName();
    }

    @Override
    public Activity.System.OperatingSystem operatingSystem() {
        return new LocalOperatingSystem();
    }

    @Override
    public Activity.System.HDD hdd() {
        File file = new File(".");
        return new Activity.System.HDD(LocalSystem.inMb(file.getTotalSpace()), LocalSystem.inMb(file.getTotalSpace() - file.getFreeSpace()), this.si.getOperatingSystem().getCurrentProcess().getHardOpenFileLimit());
    }

    @Override
    public Activity.System.RAM ram() {
        return new Activity.System.RAM(LocalSystem.inMb(this.si.getHardware().getMemory().getTotal()), 0L);
    }

    @Override
    public Activity.System.CPU cpu() {
        return new Activity.System.CPU(this.si.getHardware().getProcessor().getLogicalProcessorCount(), 0L, this.si.getHardware().getSensors().getCpuTemperature());
    }

    @Override
    public Activity.System.Network network() {
        return new Activity.System.Network(this.localIp(), this.publicIp(), this.isp());
    }

    private static long inMb(long value) {
        return value / 0x100000L;
    }

    private String localIp() {
        try {
            String hostAddress = Inet4Address.getLocalHost().getHostAddress();
            return hostAddress.equals(LOOP_BACK_ADDRESS) ? this.findInNetworkInterfaces() : hostAddress;
        }
        catch (UnknownHostException e) {
            return "0.0.0.0";
        }
    }

    private String publicIp() {
        if (this.ipInfo != null && LocalDate.now().equals(this.ipInfo.getKey())) {
            return this.ipInfo.getValue().get("ip").getAsString();
        }
        this.updateIpInfo();
        return this.ipInfo == null ? null : this.ipInfo.getValue().get("ip").getAsString();
    }

    private String isp() {
        if (this.ipInfo != null && LocalDate.now().equals(this.ipInfo.getKey())) {
            return this.ipInfo.getValue().get("org").getAsString();
        }
        this.updateIpInfo();
        return this.ipInfo == null ? null : this.ipInfo.getValue().get("org").getAsString();
    }

    private void updateIpInfo() {
        JsonObject jsonObject = this.ipInfoRequest();
        if (jsonObject != null) {
            this.ipInfo = new AbstractMap.SimpleEntry<LocalDate, JsonObject>(LocalDate.now(), jsonObject);
        }
    }

    private JsonObject ipInfoRequest() {
        try {
            URL url = new URL("http://ipinfo.io");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            if (this.ispProviderToken != null) {
                con.setRequestProperty("token", this.ispProviderToken);
            }
            con.setRequestProperty("Content-Type", "application/json");
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            con.setRequestMethod("GET");
            if (con.getResponseCode() > 210) {
                return null;
            }
            return Json.fromJson(new String(con.getInputStream().readAllBytes()).trim(), JsonObject.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    private String findInNetworkInterfaces() {
        try {
            for (InetAddress address : Collections.list(NetworkInterface.getNetworkInterfaces().nextElement().getInetAddresses())) {
                if (!(address instanceof Inet4Address) || address.isLoopbackAddress() || LOOP_BACK_ADDRESS.equals(address.getHostAddress())) continue;
                return address.getHostAddress();
            }
        }
        catch (SocketException e) {
            Logger.error(e.getMessage());
        }
        return "0.0.0.0";
    }
}

