/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.terminal.remotedatalake.measurement;

import com.google.gson.JsonObject;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.event.EventStream;
import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.measurement.MeasurementEventReader;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.remotedatalake.DatalakeAccessor;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.io.IOException;
import java.util.List;
import org.apache.activemq.BlobMessage;

public class RemoteMeasurementTub
implements Datalake.Store.Tub<MeasurementEvent> {
    private final DatalakeAccessor accessor;
    private final String tank;
    private final String source;
    private final String tub;

    public RemoteMeasurementTub(DatalakeAccessor accessor, String tank, String source, String tub) {
        this.accessor = accessor;
        this.tank = tank;
        this.source = source;
        this.tub = tub;
    }

    @Override
    public Timetag timetag() {
        return Timetag.of(this.tub);
    }

    @Override
    public EventStream<MeasurementEvent> events() {
        JsonObject jsonObject = DatalakeAccessor.reflowSchema(this.tank, this.source, List.of(this.tub));
        Message response = this.accessor.query(jsonObject.toString());
        return response instanceof BlobMessage ? RemoteMeasurementTub.openStream((BlobMessage)response) : null;
    }

    private static EventStream<MeasurementEvent> openStream(BlobMessage message) {
        try {
            return new EventStream<MeasurementEvent>(new MeasurementEventReader(message.getInputStream()));
        }
        catch (JMSException | IOException e) {
            Logger.error(e);
            return null;
        }
    }
}

