/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event;

import java.io.File;
import java.time.Instant;
import java.util.Arrays;

public interface Event
extends Comparable<Event> {
    public String type();

    public Instant ts();

    public String ss();

    public Format format();

    @Override
    default public int compareTo(Event o) {
        return this.ts().compareTo(o.ts());
    }

    public static enum Format {
        Unknown(""),
        Message(".zim"),
        Measurement(".zit"),
        Resource(".zip");

        private final String extension;

        private Format(String extension) {
            this.extension = extension;
        }

        public String extension() {
            return this.extension;
        }

        public static Format byExtension(String extension) {
            return Arrays.stream(Format.values()).filter(f -> f.extension.equalsIgnoreCase(extension)).findFirst().orElse(Unknown);
        }

        public static Format of(File file) {
            String name = file.getName();
            int index = name.lastIndexOf(46);
            return Format.byExtension(index < 0 ? "" : name.substring(index));
        }
    }
}

