package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import jakarta.jms.BytesMessage;
import jakarta.jms.Message;

import java.io.File;
import java.nio.file.Files;

public class UploadFileRequest extends ContainerRequest {
	public static final String ID = "uploadFile";

	@Override
	public String id() {
		return ID;
	}

	@Override
	public RequestResult responseTo(Message request) {
		BytesMessage message = (BytesMessage) request;
		try {
			String filename = parameter(request, "filename");
			byte[] payload = new byte[(int) message.getBodyLength()];
			message.readBytes(payload);
			String home = System.getProperty("user.home");
			File destination = new File(home, "Downloads" + File.separator + filename);
			destination.getParentFile().mkdirs();
			Files.write(destination.toPath(), payload);
			return new RequestResult(true, "File uploaded");
		} catch (Throwable e) {
			Logger.error(e);
			return new RequestResult(false, e.getMessage());
		}
	}

	@Override
	public boolean isAvailable(Message message) {
		return true;
	}
}