package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.framework.Activity;
import jakarta.jms.Message;

import java.util.Map;

import static java.util.stream.Collectors.toMap;

public class UpdateActivityConfigurationRequest extends ContainerRequest {
	public static final String ID = "updateActivityConfiguration";
	private final ContainerBox box;

	public UpdateActivityConfigurationRequest(ContainerBox box, Activity.Context context, ContainerStore store) {
		this.box = box;
	}

	@Override
	public String id() {
		return ID;
	}

	@Override
	public RequestResult responseTo(Message request) {
		try {
			String activityId = activity(request);
			if (activityId == null) return new RequestResult(false, "Activity not found");
			Map<String, String> params = activityParameters(request).entrySet().stream()
					.collect(toMap(Map.Entry::getKey, e -> e.getValue().getAsString()));
			Activity.Result result = box.activities().updateConfiguration(activityId, params);
			return new RequestResult(result.success(), result.remarks());
		} catch (Throwable e) {
			Logger.error(e);
			return new RequestResult(false, e.getMessage());
		}
	}

	@Override
	public boolean isAvailable(Message message) {
		return true;
	}
}