package io.intino.consul.container.box.service.requests;

import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.framework.utils.Utils;
import jakarta.jms.Message;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class InfoRequest extends ContainerRequest {
	public static final String ID = "info";
	private final ContainerBox box;

	public InfoRequest(ContainerBox box) {
		this.box = box;
	}

	@Override
	public String id() {
		return ID;
	}

	@Override
	public RequestResult responseTo(Message request) {
		RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
		return new RequestResult(true, new Info(box.observer(), Utils.currentVersion(), Instant.now().minus(rb.getUptime(), ChronoUnit.MILLIS)));
	}

	@Override
	public boolean isAvailable(Message message) {
		return true;
	}

	public record Info(String host, String consulVersion, Instant startDate) {
	}
}