package io.intino.consul.container.box.service;

import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.container.box.service.requests.*;
import io.intino.consul.terminal.ConsulService;

public class ServiceConfigurator {
	private static final String SEP = "#";
	private static final String PREFIX = "container";
	private final ContainerBox box;

	public ServiceConfigurator(ContainerBox box) {
		this.box = box;
	}

	public void configure(ConsulService service) {
		ContainerStore store = (ContainerStore) box.store();
		service.register(PREFIX + SEP + ActivitiesRequest.ID, new ActivitiesRequest(box));
		service.register(PREFIX + SEP + InfoRequest.ID, new InfoRequest(box));
		service.register(PREFIX + SEP + FactoryResetRequest.ID, new FactoryResetRequest(box, box.context(), store));
		service.register(PREFIX + SEP + RestartConsulRequest.ID, new RestartConsulRequest());
		service.register(PREFIX + SEP + InstallActivityRequest.ID, new InstallActivityRequest(box, box.context(), store));
		service.register(PREFIX + SEP + UpgradeActivityRequest.ID, new UpgradeActivityRequest(box, box.context(), store));
		service.register(PREFIX + SEP + EnableActivityRequest.ID, new EnableActivityRequest(box, box.context()));
		service.register(PREFIX + SEP + DisableActivityRequest.ID, new DisableActivityRequest(box, box.context(), store));
		service.register(PREFIX + SEP + UninstallActivityRequest.ID, new UninstallActivityRequest(box, box.context()));
		service.register(PREFIX + SEP + GetActivityConfigurationRequest.ID, new GetActivityConfigurationRequest(box, box.context(), store));
		service.register(PREFIX + SEP + UpdateActivityConfigurationRequest.ID, new UpdateActivityConfigurationRequest(box, box.context(), store));
		service.register(PREFIX + SEP + UpgradeRequest.ID, new UpgradeRequest(box, box.configuration()));
		service.register(PREFIX + SEP + UploadFileRequest.ID, new UploadFileRequest());
		service.register(PREFIX + SEP + RunScriptRequest.ID, new RunScriptRequest(box, box.context(), store));
		service.register(PREFIX + SEP + ExploreFileSystemRequest.ID, new ExploreFileSystemRequest());
	}
}
