package io.intino.consul.container.box.schemas;

import io.intino.consul.container.box.schemas.*;

public class Manifest implements java.io.Serializable {

	private String name;
	private String description;
	private Boolean needInstallToConfig = false;
	private java.util.List<String> dependantActivities = new java.util.ArrayList<>();
	private java.util.List<Parameter> parameters = new java.util.ArrayList<>();
	private Container container;
	private Service service;

	public String name() {
		return this.name;
	}

	public String description() {
		return this.description;
	}

	public Boolean needInstallToConfig() {
		return this.needInstallToConfig;
	}

	public java.util.List<String> dependantActivities() {
		return this.dependantActivities;
	}

	public java.util.List<Parameter> parameters() {
		return this.parameters;
	}

	public Container container() {
		return this.container;
	}

	public Service service() {
		return this.service;
	}

	public Manifest name(String name) {
		this.name = name;
		return this;
	}

	public Manifest description(String description) {
		this.description = description;
		return this;
	}

	public Manifest needInstallToConfig(Boolean needInstallToConfig) {
		this.needInstallToConfig = needInstallToConfig;
		return this;
	}

	public Manifest dependantActivities(java.util.List<String> dependantActivities) {
		this.dependantActivities = dependantActivities;
		return this;
	}

	public Manifest parameters(java.util.List<Parameter> parameters) {
		this.parameters = parameters;
		return this;
	}

	public Manifest container(Container container) {
		this.container = container;
		return this;
	}

	public Manifest service(Service service) {
		this.service = service;
		return this;
	}

	public static class Container implements java.io.Serializable {

		private String minVersion;
		private String maxVersion;

		public String minVersion() {
			return this.minVersion;
		}

		public String maxVersion() {
			return this.maxVersion;
		}

		public Container minVersion(String minVersion) {
			this.minVersion = minVersion;
			return this;
		}

		public Container maxVersion(String maxVersion) {
			this.maxVersion = maxVersion;
			return this;
		}
	}

	public static class Service implements java.io.Serializable {

		private java.util.List<Endpoint> endpoint = new java.util.ArrayList<>();

		public java.util.List<Endpoint> endpointList() {
			return this.endpoint;
		}

		public java.util.List<Endpoint> endpointList(java.util.function.Predicate<Endpoint> predicate) {
			return this.endpoint.stream().filter(predicate).collect(java.util.stream.Collectors.toList());
		}

		public Endpoint endpoint(java.util.function.Predicate<Endpoint> predicate) {
			return this.endpoint.stream().filter(predicate).findFirst().orElse(null);
		}


		public Service endpointList(java.util.List<Endpoint> endpoint) {
			this.endpoint = endpoint;
			return this;
		}

		public static class Endpoint implements java.io.Serializable {

			private String name;
			private String label;
			private String icon;
			private String description;
			private java.util.List<Parameter> parameters = new java.util.ArrayList<>();
			private Response response;

			public String name() {
				return this.name;
			}

			public String label() {
				return this.label;
			}

			public String icon() {
				return this.icon;
			}

			public String description() {
				return this.description;
			}

			public java.util.List<Parameter> parameters() {
				return this.parameters;
			}

			public Response response() {
				return this.response;
			}

			public Endpoint name(String name) {
				this.name = name;
				return this;
			}

			public Endpoint label(String label) {
				this.label = label;
				return this;
			}

			public Endpoint icon(String icon) {
				this.icon = icon;
				return this;
			}

			public Endpoint description(String description) {
				this.description = description;
				return this;
			}

			public Endpoint parameters(java.util.List<Parameter> parameters) {
				this.parameters = parameters;
				return this;
			}

			public Endpoint response(Response response) {
				this.response = response;
				return this;
			}

			public static class Response implements java.io.Serializable {

				private String type;
				private String description;

				public String type() {
					return this.type;
				}

				public String description() {
					return this.description;
				}

				public Response type(String type) {
					this.type = type;
					return this;
				}

				public Response description(String description) {
					this.description = description;
					return this;
				}
			}
		}
	}
}