package io.intino.consul.container.box.os.remote;

import com.jcraft.jsch.Channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SftpInputStream extends InputStream {
	private final InputStream is;
	private final Channel channel;

	public SftpInputStream(InputStream is, Channel channel) {
		this.is = is;
		this.channel = channel;
	}

	@Override
	public int read() throws IOException {
		return is.read();
	}

	@Override
	public int read(byte[] b) throws IOException {
		return is.read(b);
	}

	@Override
	public int read(byte[] b, int off, int len) throws IOException {
		return is.read(b, off, len);
	}

	@Override
	public byte[] readAllBytes() throws IOException {
		return is.readAllBytes();
	}

	@Override
	public byte[] readNBytes(int len) throws IOException {
		return is.readNBytes(len);
	}

	@Override
	public int readNBytes(byte[] b, int off, int len) throws IOException {
		return is.readNBytes(b, off, len);
	}

	@Override
	public long skip(long n) throws IOException {
		return is.skip(n);
	}

	@Override
	public void skipNBytes(long n) throws IOException {
		is.skipNBytes(n);
	}

	@Override
	public int available() throws IOException {
		return is.available();
	}

	@Override
	public void close() throws IOException {
		is.close();
		channel.disconnect();
	}

	@Override
	public void mark(int readlimit) {
		is.mark(readlimit);
	}

	@Override
	public void reset() throws IOException {
		is.reset();
	}

	@Override
	public boolean markSupported() {
		return is.markSupported();
	}

	@Override
	public long transferTo(OutputStream out) throws IOException {
		return is.transferTo(out);
	}
}
