package io.intino.consul.container.box.os.remote;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.intino.consul.framework.Activity;

import java.io.ByteArrayOutputStream;
import java.util.List;

record RemoteProcessRunner(Session session) implements Activity.System.ProcessRunner {

	@Override
	public String execute(List<String> command, int timeoutSeconds) throws Exception {
		if (!session.isConnected()) session.connect();
		ByteArrayOutputStream response = new ByteArrayOutputStream();
		sendCommand(command, response, timeoutSeconds);
		return response.toString();
	}

	private void sendCommand(List<String> command, ByteArrayOutputStream response, int timeoutSeconds) throws JSchException, InterruptedException {
		ChannelExec channel = null;
		String cmd = String.join(" ", command);
		try {
			channel = send(cmd, response, timeoutSeconds);
		} catch (JSchException e) {
			if (e.getMessage().contains("Packet corrupt")) channel = send(cmd, response, timeoutSeconds);
			else throw e;
		} catch (InterruptedException ignored) {
		} finally {
			if (channel != null) channel.disconnect();
		}
	}

	private ChannelExec send(String command, ByteArrayOutputStream response, int timeoutSeconds) throws JSchException, InterruptedException {
		ChannelExec channel = (ChannelExec) session.openChannel("exec");
		channel.setCommand("export LANG=en_EN.UTF-8;"+command);
		channel.setOutputStream(response);
		channel.connect(timeoutSeconds * 1000);
		while (channel.isConnected()) Thread.sleep(100);
		return channel;
	}
}
