package io.intino.consul.container.box.activity;

import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.framework.Activity;

import java.io.File;
import java.lang.reflect.Type;
import java.util.stream.Stream;

public class ActivityStore implements Activity.Store {
	private final ContainerStore store;
	private final String prefix;
	private final File workingDirectory;

	public ActivityStore(String activityID, ContainerStore store) {
		this.store = store;
		this.prefix = activityID + Separator;
		this.workingDirectory = new File(store.workingDirectory(), activityID.replace(":", ""));
		this.workingDirectory.mkdirs();
	}

	@Override
	public void put(String key, Object object) {
		store.put(prefix + key, object);
	}

	@Override
	public <T> T get(String key, Class<T> aClass) {
		return store.get(prefix + key, aClass);
	}

	@Override
	public <T> T get(String key, Type type) {
		return store.get(prefix + key, type);
	}

	@Override
	public Stream<String> keys() {
		return store.keys().filter(k -> k.startsWith(prefix)).map(k -> k.replace(prefix, ""));
	}

	@Override
	public File workingDirectory() {
		return workingDirectory;
	}

	@Override
	public void remove(String key) {
		store.remove(prefix + key);
	}
}
