/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.validation.metric.ClassificationMetric;

public class Fallout
implements ClassificationMetric {
    private static final long serialVersionUID = 2L;
    public static final Fallout instance = new Fallout();

    @Override
    public double score(int[] truth, int[] prediction) {
        return Fallout.of(truth, prediction);
    }

    public static double of(int[] truth, int[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        int tn = 0;
        int n = 0;
        for (int i = 0; i < truth.length; ++i) {
            if (truth[i] != 0 && truth[i] != 1) {
                throw new IllegalArgumentException("Fallout can only be applied to binary classification: " + truth[i]);
            }
            if (prediction[i] != 0 && prediction[i] != 1) {
                throw new IllegalArgumentException("Fallout can only be applied to binary classification: " + prediction[i]);
            }
            if (truth[i] == 1) continue;
            ++n;
            if (prediction[i] != truth[i]) continue;
            ++tn;
        }
        return 1.0 - (double)tn / (double)n;
    }

    public String toString() {
        return "FallOut";
    }
}

