/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.sort.QuickSort;
import smile.validation.metric.ProbabilisticClassificationMetric;

public class AUC
implements ProbabilisticClassificationMetric {
    private static final long serialVersionUID = 2L;
    public static final AUC instance = new AUC();

    @Override
    public double score(int[] truth, double[] probability) {
        return AUC.of(truth, probability);
    }

    public static double of(int[] truth, double[] probability) {
        if (truth.length != probability.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, probability.length));
        }
        double pos = 0.0;
        double neg = 0.0;
        for (int label : truth) {
            if (label == 0) {
                neg += 1.0;
                continue;
            }
            if (label == 1) {
                pos += 1.0;
                continue;
            }
            throw new IllegalArgumentException("AUC is only for binary classification. Invalid label: " + label);
        }
        int[] label = (int[])truth.clone();
        double[] prediction = (double[])probability.clone();
        QuickSort.sort(prediction, label);
        double[] rank = new double[label.length];
        for (int i = 0; i < prediction.length; ++i) {
            int j;
            if (i == prediction.length - 1 || prediction[i] != prediction[i + 1]) {
                rank[i] = i + 1;
                continue;
            }
            for (j = i + 1; j < prediction.length && prediction[j] == prediction[i]; ++j) {
            }
            double r = (double)(i + 1 + j) / 2.0;
            for (int k = i; k < j; ++k) {
                rank[k] = r;
            }
            i = j - 1;
        }
        double auc = 0.0;
        for (int i = 0; i < label.length; ++i) {
            if (label[i] != 1) continue;
            auc += rank[i];
        }
        auc = (auc - pos * (pos + 1.0) / 2.0) / (pos * neg);
        return auc;
    }

    public String toString() {
        return "AUC";
    }
}

