/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.io.Serializable;
import java.util.List;
import smile.math.MathEx;
import smile.validation.ClassificationMetrics;
import smile.validation.ClassificationValidation;

public class ClassificationValidations<M>
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final List<ClassificationValidation<M>> rounds;
    public final ClassificationMetrics avg;
    public final ClassificationMetrics sd;

    public ClassificationValidations(List<ClassificationValidation<M>> rounds) {
        this.rounds = rounds;
        int k = rounds.size();
        double[] fitTime = new double[k];
        double[] scoreTime = new double[k];
        int[] size = new int[k];
        int[] error = new int[k];
        double[] accuracy = new double[k];
        double[] sensitivity = new double[k];
        double[] specificity = new double[k];
        double[] precision = new double[k];
        double[] f1 = new double[k];
        double[] mcc = new double[k];
        double[] auc = new double[k];
        double[] logloss = new double[k];
        double[] crossentropy = new double[k];
        for (int i = 0; i < k; ++i) {
            ClassificationMetrics metrics = rounds.get((int)i).metrics;
            fitTime[i] = metrics.fitTime;
            scoreTime[i] = metrics.scoreTime;
            size[i] = metrics.size;
            error[i] = metrics.error;
            accuracy[i] = metrics.accuracy;
            sensitivity[i] = metrics.sensitivity;
            specificity[i] = metrics.specificity;
            precision[i] = metrics.precision;
            f1[i] = metrics.f1;
            mcc[i] = metrics.mcc;
            auc[i] = metrics.auc;
            logloss[i] = metrics.logloss;
            crossentropy[i] = metrics.crossentropy;
        }
        this.avg = new ClassificationMetrics(MathEx.mean(fitTime), MathEx.mean(scoreTime), (int)Math.round(MathEx.mean(size)), (int)Math.round(MathEx.mean(error)), MathEx.mean(accuracy), MathEx.mean(sensitivity), MathEx.mean(specificity), MathEx.mean(precision), MathEx.mean(f1), MathEx.mean(mcc), MathEx.mean(auc), MathEx.mean(logloss), MathEx.mean(crossentropy));
        this.sd = new ClassificationMetrics(MathEx.sd(fitTime), MathEx.sd(scoreTime), (int)Math.round(MathEx.sd(size)), (int)Math.round(MathEx.sd(error)), MathEx.sd(accuracy), MathEx.sd(sensitivity), MathEx.sd(specificity), MathEx.sd(precision), MathEx.sd(f1), MathEx.sd(mcc), MathEx.sd(auc), MathEx.sd(logloss), MathEx.sd(crossentropy));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n");
        sb.append(String.format("  fit time: %.3f ms \u00b1 %.3f,\n", this.avg.fitTime, this.sd.fitTime));
        sb.append(String.format("  score time: %.3f ms \u00b1 %.3f,\n", this.avg.scoreTime, this.sd.scoreTime));
        sb.append(String.format("  validation data size: %d \u00b1 %d,\n", this.avg.size, this.sd.size));
        sb.append(String.format("  error: %d \u00b1 %d,\n", this.avg.error, this.sd.error));
        sb.append(String.format("  accuracy: %.2f%% \u00b1 %.2f", 100.0 * this.avg.accuracy, 100.0 * this.sd.accuracy));
        if (!Double.isNaN(this.avg.sensitivity)) {
            sb.append(String.format(",\n  sensitivity: %.2f%% \u00b1 %.2f", 100.0 * this.avg.sensitivity, 100.0 * this.sd.sensitivity));
        }
        if (!Double.isNaN(this.avg.specificity)) {
            sb.append(String.format(",\n  specificity: %.2f%% \u00b1 %.2f", 100.0 * this.avg.specificity, 100.0 * this.sd.specificity));
        }
        if (!Double.isNaN(this.avg.precision)) {
            sb.append(String.format(",\n  precision: %.2f%% \u00b1 %.2f", 100.0 * this.avg.precision, 100.0 * this.sd.precision));
        }
        if (!Double.isNaN(this.avg.f1)) {
            sb.append(String.format(",\n  F1 score: %.2f%% \u00b1 %.2f", 100.0 * this.avg.f1, 100.0 * this.sd.f1));
        }
        if (!Double.isNaN(this.avg.mcc)) {
            sb.append(String.format(",\n  MCC: %.2f%% \u00b1 %.2f", 100.0 * this.avg.mcc, 100.0 * this.sd.mcc));
        }
        if (!Double.isNaN(this.avg.auc)) {
            sb.append(String.format(",\n  AUC: %.2f%% \u00b1 %.2f", 100.0 * this.avg.auc, 100.0 * this.sd.auc));
        }
        if (!Double.isNaN(this.avg.logloss)) {
            sb.append(String.format(",\n  log loss: %.4f \u00b1 %.4f", this.avg.logloss, this.sd.logloss));
        } else if (!Double.isNaN(this.avg.crossentropy)) {
            sb.append(String.format(",\n  cross entropy: %.4f \u00b1 %.4f", this.avg.crossentropy, this.sd.crossentropy));
        }
        sb.append("\n}");
        return sb.toString();
    }
}

