/*
 * Decompiled with CFR 0.152.
 */
package smile.timeseries;

import java.io.Serializable;
import java.util.Arrays;
import smile.math.MathEx;
import smile.math.matrix.Matrix;
import smile.math.special.Beta;
import smile.stat.Hypothesis;
import smile.timeseries.TimeSeries;

public class AR
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final double[] x;
    private final double mean;
    private final Method method;
    private final int p;
    private final double b;
    private final double[] ar;
    private double[][] ttest;
    private final double[] fittedValues;
    private final double[] residuals;
    private double RSS;
    private double variance;
    private final int df;
    private final double R2;
    private final double adjustedR2;

    public AR(double[] x, double[] ar, double b, Method method) {
        this.x = x;
        this.p = ar.length;
        this.ar = ar;
        this.b = b;
        this.method = method;
        this.mean = MathEx.mean(x);
        double[] y = AR.y(x, this.p);
        double ybar = MathEx.mean(y);
        int n = y.length;
        double TSS = 0.0;
        this.RSS = 0.0;
        this.fittedValues = new double[n];
        this.residuals = new double[n];
        for (int i = 0; i < n; ++i) {
            double residual;
            double yi;
            this.fittedValues[i] = yi = this.forecast(x, this.p + i);
            this.residuals[i] = residual = y[i] - yi;
            this.RSS += MathEx.pow2(residual);
            TSS += MathEx.pow2(y[i] - ybar);
        }
        this.df = x.length - this.p;
        this.variance = this.RSS / (double)this.df;
        this.R2 = 1.0 - this.RSS / TSS;
        this.adjustedR2 = 1.0 - (1.0 - this.R2) * (double)(n - 1) / (double)(n - this.p);
    }

    private static Matrix X(double[] x, int p) {
        int n = x.length - p;
        Matrix X = new Matrix(n, p + 1);
        for (int j = 0; j < p; ++j) {
            for (int i = 0; i < n; ++i) {
                X.set(i, j, x[i + p - j - 1]);
            }
        }
        for (int i = 0; i < n; ++i) {
            X.set(i, p, 1.0);
        }
        return X;
    }

    private static double[] y(double[] x, int p) {
        return Arrays.copyOfRange(x, p, x.length);
    }

    public double[] x() {
        return this.x;
    }

    public double mean() {
        return this.mean;
    }

    public int p() {
        return this.p;
    }

    public double[][] ttest() {
        return this.ttest;
    }

    public double[] ar() {
        return this.ar;
    }

    public double intercept() {
        return this.b;
    }

    public double[] residuals() {
        return this.residuals;
    }

    public double[] fittedValues() {
        return this.fittedValues;
    }

    public double RSS() {
        return this.RSS;
    }

    public double variance() {
        return this.variance;
    }

    public int df() {
        return this.df;
    }

    public double R2() {
        return this.R2;
    }

    public double adjustedR2() {
        return this.adjustedR2;
    }

    public static AR fit(double[] x, int p) {
        if (p <= 0 || p >= x.length) {
            throw new IllegalArgumentException("Invalid order p = " + p);
        }
        double mean = MathEx.mean(x);
        double[] y = new double[p];
        for (int i = 0; i < p; ++i) {
            y[i] = TimeSeries.acf(x, i + 1);
        }
        double[] r = new double[p];
        r[0] = 1.0;
        System.arraycopy(y, 0, r, 1, p - 1);
        Matrix toeplitz = Matrix.toeplitz(r);
        Matrix.Cholesky cholesky = toeplitz.cholesky();
        double[] ar = cholesky.solve(y);
        double mu = mean * (1.0 - MathEx.sum(ar));
        AR model = new AR(x, ar, mu, Method.YuleWalker);
        double aracf = 0.0;
        for (int i = 0; i < p; ++i) {
            aracf += ar[i] * y[i];
        }
        model.variance = MathEx.var(x) * (double)(x.length - 1) / (double)(x.length - p - 1) * (1.0 - aracf);
        return model;
    }

    public static AR ols(double[] x, int p) {
        return AR.ols(x, p, true);
    }

    public static AR ols(double[] x, int p, boolean stderr) {
        if (p <= 0 || p >= x.length) {
            throw new IllegalArgumentException("Invalid order p = " + p);
        }
        Matrix X = AR.X(x, p);
        double[] y = AR.y(x, p);
        Matrix.SVD svd = X.svd(true, !stderr);
        double[] ar = svd.solve(y);
        AR model = new AR(x, Arrays.copyOf(ar, p), ar[p], Method.OLS);
        if (stderr) {
            Matrix.Cholesky cholesky = X.ata().cholesky(true);
            Matrix inv = cholesky.inverse();
            int df = model.df;
            double error = Math.sqrt(model.variance);
            double[][] ttest = new double[p][4];
            model.ttest = ttest;
            for (int i = 0; i < p; ++i) {
                double t2;
                double se;
                ttest[i][0] = ar[i];
                ttest[i][1] = se = error * Math.sqrt(inv.get(i, i));
                ttest[i][2] = t2 = ar[i] / se;
                ttest[i][3] = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t2 * t2));
            }
        }
        return model;
    }

    private double forecast(double[] x, int offset) {
        double y = this.b;
        for (int i = 0; i < this.p; ++i) {
            y += this.ar[i] * x[offset - i - 1];
        }
        return y;
    }

    public double forecast() {
        return this.forecast(this.x, this.x.length);
    }

    public double[] forecast(int l) {
        double[] x = new double[this.p + l];
        System.arraycopy(this.x, this.x.length - this.p, x, 0, this.p);
        for (int i = 0; i < l; ++i) {
            x[this.p + i] = this.forecast(x, this.p + i);
        }
        return Arrays.copyOfRange(x, this.p, x.length);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("AR(%d) by %s:\n", new Object[]{this.p, this.method}));
        double[] r = (double[])this.residuals.clone();
        builder.append("\nResiduals:\n");
        builder.append("       Min          1Q      Median          3Q         Max\n");
        builder.append(String.format("%10.4f  %10.4f  %10.4f  %10.4f  %10.4f%n", MathEx.min(r), MathEx.q1(r), MathEx.median(r), MathEx.q3(r), MathEx.max(r)));
        builder.append("\nCoefficients:\n");
        if (this.ttest != null) {
            builder.append("              Estimate Std. Error    t value   Pr(>|t|)\n");
            if (this.b != 0.0) {
                builder.append(String.format("Intercept   %10.4f%n", this.b));
            }
            for (int i = 0; i < this.p; ++i) {
                builder.append(String.format("x[-%d]\t    %10.4f %10.4f %10.4f %10.4f %s%n", i + 1, this.ttest[i][0], this.ttest[i][1], this.ttest[i][2], this.ttest[i][3], Hypothesis.significance(this.ttest[i][3])));
            }
            builder.append("---------------------------------------------------------------------\n");
            builder.append("Significance codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1\n");
        } else {
            if (this.b != 0.0) {
                builder.append(String.format("Intercept   %10.4f%n", this.b));
            }
            for (int i = 0; i < this.p; ++i) {
                builder.append(String.format("x[-%d]\t    %10.4f%n", i + 1, this.ar[i]));
            }
        }
        builder.append(String.format("%nResidual  variance: %.4f on %5d degrees of freedom%n", this.variance, this.df));
        builder.append(String.format("Multiple R-squared: %.4f, Adjusted R-squared: %.4f%n", this.R2, this.adjustedR2));
        return builder.toString();
    }

    public static enum Method {
        YuleWalker{

            public String toString() {
                return "Yule-Walker";
            }
        }
        ,
        OLS;

    }
}

