/*
 * Decompiled with CFR 0.152.
 */
package smile.hash;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import smile.hash.PerfectHash;

public class PerfectMap<T> {
    private final PerfectHash hash;
    private final List<T> values;

    private PerfectMap(PerfectHash hash, List<T> values) {
        this.hash = hash;
        this.values = values;
    }

    public T get(String key) {
        int i = this.hash.get(key);
        if (i < 0) {
            return null;
        }
        return this.values.get(i);
    }

    public static class Builder<T> {
        private final Map<String, T> map = new HashMap<String, T>();

        public Builder() {
        }

        public Builder(Map<String, T> map) {
            this.map.putAll(map);
        }

        public Builder<T> add(String key, T value) {
            this.map.put(key, value);
            return this;
        }

        public PerfectMap<T> build() {
            String[] keys = new String[this.map.size()];
            ArrayList<T> values = new ArrayList<T>();
            int i = 0;
            for (Map.Entry<String, T> e : this.map.entrySet()) {
                keys[i++] = e.getKey();
                values.add(e.getValue());
            }
            return new PerfectMap(new PerfectHash(keys), values);
        }
    }
}

