/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.selection;

import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.IntStream;
import smile.classification.ClassLabels;
import smile.data.DataFrame;
import smile.data.measure.NominalScale;
import smile.data.transform.ColumnTransform;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.math.Function;
import smile.sort.QuickSort;

public class InformationValue
implements Comparable<InformationValue> {
    public final String feature;
    public final double iv;
    public final double[] woe;
    public final double[] breaks;

    public InformationValue(String feature, double iv, double[] woe, double[] breaks) {
        this.feature = feature;
        this.iv = iv;
        this.woe = woe;
        this.breaks = breaks;
    }

    @Override
    public int compareTo(InformationValue other) {
        return Double.compare(this.iv, other.iv);
    }

    public String toString() {
        return String.format("InformationValue(%s, %.4f)", this.feature, this.iv);
    }

    private static String predictivePower(double iv) {
        if (Double.isNaN(iv)) {
            return "";
        }
        if (iv < 0.02) {
            return "Not useful";
        }
        if (iv <= 0.1) {
            return "Weak";
        }
        if (iv <= 0.3) {
            return "Medium";
        }
        if (iv <= 0.5) {
            return "Strong";
        }
        return "Suspicious";
    }

    public static String toString(InformationValue[] iv) {
        StringBuilder builder = new StringBuilder();
        builder.append("Feature                   Information Value    Predictive Power\n");
        for (int i = 0; i < iv.length; ++i) {
            builder.append(String.format("%-25s %17.4f    %16s%n", iv[i].feature, iv[i].iv, InformationValue.predictivePower(iv[i].iv)));
        }
        return builder.toString();
    }

    public static ColumnTransform toTransform(InformationValue[] values) {
        HashMap<String, Function> transforms = new HashMap<String, Function>();
        for (final InformationValue iv : values) {
            Function transform = new Function(){

                @Override
                public double f(double x) {
                    if (iv.breaks == null) {
                        int i = (int)x;
                        if (i < 0 || i >= iv.woe.length) {
                            throw new IllegalArgumentException("Invalid nominal value: " + i);
                        }
                        return iv.woe[i];
                    }
                    int i = Arrays.binarySearch(iv.breaks, x);
                    if (i < 0) {
                        i = -i - 1;
                    }
                    return iv.woe[i];
                }

                public String toString() {
                    return iv.feature + "_WoE";
                }
            };
            transforms.put(iv.feature, transform);
        }
        return new ColumnTransform("WoE", transforms);
    }

    public static InformationValue[] fit(DataFrame data, String clazz) {
        return InformationValue.fit(data, clazz, 10);
    }

    public static InformationValue[] fit(DataFrame data, String clazz, int nbins) {
        if (nbins < 2) {
            throw new IllegalArgumentException("Invalid number of bins: " + nbins);
        }
        BaseVector y = data.column(clazz);
        ClassLabels codec = ClassLabels.fit(y);
        if (codec.k != 2) {
            throw new UnsupportedOperationException("Information Value is applicable only to binary classification");
        }
        int n = data.nrow();
        StructType schema = data.schema();
        return (InformationValue[])IntStream.range(0, schema.length()).mapToObj(i -> {
            int k;
            int[] events = null;
            int[] nonevents = null;
            double[] breaks = null;
            StructField field = schema.field(i);
            if (field.measure instanceof NominalScale) {
                k = ((NominalScale)field.measure).size();
                events = new int[k];
                nonevents = new int[k];
                int[] xi = data.column(i).toIntArray();
                for (int j = 0; j < n; ++j) {
                    if (codec.y[j] == 1) {
                        int n2 = xi[j];
                        events[n2] = events[n2] + 1;
                        continue;
                    }
                    int n3 = xi[j];
                    nonevents[n3] = nonevents[n3] + 1;
                }
            } else if (field.isNumeric()) {
                events = new int[nbins];
                nonevents = new int[nbins];
                breaks = new double[nbins - 1];
                double[] xi = data.column(i).toDoubleArray();
                int[] order = QuickSort.sort(xi);
                int begin = 0;
                for (int j = 0; j < nbins; ++j) {
                    int end = (j + 1) * n / nbins;
                    if (j < nbins - 1) {
                        breaks[j] = xi[end];
                    }
                    for (int k2 = begin; k2 < end; ++k2) {
                        if (codec.y[order[k2]] == 1) {
                            int n4 = j;
                            events[n4] = events[n4] + 1;
                            continue;
                        }
                        int n5 = j;
                        nonevents[n5] = nonevents[n5] + 1;
                    }
                    begin = end;
                }
            } else {
                return null;
            }
            k = events.length;
            double[] woe = new double[k];
            double iv = 0.0;
            for (int j = 0; j < k; ++j) {
                double pnonevents = Math.max((double)nonevents[j], 0.5) / (double)codec.ni[0];
                double pevents = Math.max((double)events[j], 0.5) / (double)codec.ni[1];
                woe[j] = Math.log(pnonevents / pevents);
                iv += (pnonevents - pevents) * woe[j];
            }
            return new InformationValue(field.name, iv, woe, breaks);
        }).filter(iv -> iv != null && !iv.feature.equals(clazz)).toArray(InformationValue[]::new);
    }
}

