/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.extraction;

import smile.feature.extraction.Projection;
import smile.math.MathEx;
import smile.math.matrix.Matrix;
import smile.stat.distribution.GaussianDistribution;

public class RandomProjection
extends Projection {
    private static final long serialVersionUID = 2L;
    private static final double[] prob = new double[]{0.16666666666666666, 0.6666666666666666, 0.16666666666666666};

    public RandomProjection(Matrix projection, String ... columns) {
        super(projection, "RP", columns);
    }

    public static RandomProjection of(int n, int p, String ... columns) {
        int j;
        int i;
        if (n < 2) {
            throw new IllegalArgumentException("Invalid dimension of input space: " + n);
        }
        if (p < 1 || p > n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        double[][] projection = new double[p][n];
        GaussianDistribution gauss = GaussianDistribution.getInstance();
        for (i = 0; i < p; ++i) {
            for (j = 0; j < n; ++j) {
                projection[i][j] = gauss.rand();
            }
        }
        MathEx.unitize(projection[0]);
        for (i = 1; i < p; ++i) {
            for (j = 0; j < i; ++j) {
                double t2 = -MathEx.dot(projection[i], projection[j]);
                MathEx.axpy(t2, projection[j], projection[i]);
            }
            MathEx.unitize(projection[i]);
        }
        return new RandomProjection(Matrix.of(projection), columns);
    }

    public static RandomProjection sparse(int n, int p, String ... columns) {
        if (n < 2) {
            throw new IllegalArgumentException("Invalid dimension of input space: " + n);
        }
        if (p < 1 || p > n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        Matrix projection = new Matrix(p, n);
        double scale = Math.sqrt(3.0);
        for (int i = 0; i < p; ++i) {
            for (int j = 0; j < n; ++j) {
                projection.set(i, j, scale * (double)(MathEx.random(prob) - 1));
            }
        }
        return new RandomProjection(projection, columns);
    }
}

