/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.extraction;

import java.util.stream.IntStream;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.transform.Transform;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.data.vector.DoubleVector;
import smile.math.matrix.Matrix;

public class Projection
implements Transform {
    public final Matrix projection;
    public final StructType schema;
    public final String[] columns;

    public Projection(Matrix projection, String prefix, String ... columns) {
        this.projection = projection;
        int p = projection.nrow();
        StructField[] fields = (StructField[])IntStream.range(1, p + 1).mapToObj(i -> new StructField(prefix + i, DataTypes.DoubleType)).toArray(StructField[]::new);
        this.schema = new StructType(fields);
        this.columns = columns;
    }

    @Override
    public Tuple apply(Tuple x) {
        double[] y = this.apply(x.toArray(this.columns));
        return Tuple.of(y, this.schema);
    }

    @Override
    public DataFrame apply(DataFrame data) {
        double[][] y = this.apply(data.toArray(this.columns));
        int n = data.size();
        int p = this.projection.nrow();
        BaseVector[] vectors = new DoubleVector[p];
        for (int j = 0; j < p; ++j) {
            double[] x = new double[n];
            for (int i = 0; i < x.length; ++i) {
                x[i] = y[i][j];
            }
            vectors[j] = DoubleVector.of(this.schema.field(j), x);
        }
        return DataFrame.of(vectors);
    }

    @Override
    public double[] apply(double[] x) {
        return this.postprocess(this.projection.mv(this.preprocess(x)));
    }

    @Override
    public double[][] apply(double[][] x) {
        double[][] y = new double[x.length][];
        for (int i = 0; i < x.length; ++i) {
            y[i] = this.apply(x[i]);
        }
        return y;
    }

    protected double[] preprocess(double[] x) {
        return x;
    }

    protected double[] postprocess(double[] x) {
        return x;
    }
}

