/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.extraction;

import smile.data.DataFrame;
import smile.feature.extraction.Projection;
import smile.math.MathEx;
import smile.math.blas.UPLO;
import smile.math.matrix.Matrix;

public class ProbabilisticPCA
extends Projection {
    private static final long serialVersionUID = 2L;
    private final double[] mu;
    private final double[] pmu;
    private final double noise;
    private final Matrix loading;

    public ProbabilisticPCA(double noise, double[] mu, Matrix loading, Matrix projection, String ... columns) {
        super(projection, "PPCA", columns);
        this.noise = noise;
        this.mu = mu;
        this.loading = loading;
        this.pmu = new double[projection.nrow()];
        projection.mv(mu, this.pmu);
    }

    public Matrix loadings() {
        return this.loading;
    }

    public double[] center() {
        return this.mu;
    }

    public double variance() {
        return this.noise;
    }

    @Override
    protected double[] postprocess(double[] x) {
        MathEx.sub(x, this.pmu);
        return x;
    }

    public static ProbabilisticPCA fit(DataFrame data, int k, String ... columns) {
        double[][] x = data.toArray(columns);
        return ProbabilisticPCA.fit(x, k, columns);
    }

    public static ProbabilisticPCA fit(double[][] data, int k, String ... columns) {
        int m = data.length;
        int n = data[0].length;
        double[] mu = MathEx.colMeans(data);
        Matrix cov = new Matrix(n, n);
        for (double[] datum : data) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j <= i; ++j) {
                    cov.add(i, j, (datum[i] - mu[i]) * (datum[j] - mu[j]));
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                cov.div(i, j, m);
                cov.set(j, i, cov.get(i, j));
            }
        }
        cov.uplo(UPLO.LOWER);
        Matrix.EVD eigen = cov.eigen(false, true, true).sort();
        double[] eigvalues = eigen.wr;
        Matrix eigvectors = eigen.Vr;
        double noise = 0.0;
        for (int i = k; i < n; ++i) {
            noise += eigvalues[i];
        }
        noise /= (double)(n - k);
        Matrix loading = new Matrix(n, k);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < k; ++j) {
                loading.set(i, j, eigvectors.get(i, j) * Math.sqrt(eigvalues[j] - noise));
            }
        }
        Matrix M2 = loading.ata();
        M2.addDiag(noise);
        Matrix.Cholesky chol = M2.cholesky(true);
        Matrix Mi = chol.inverse();
        Matrix projection = Mi.mt(loading);
        return new ProbabilisticPCA(noise, mu, loading, projection, columns);
    }
}

