/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.extraction;

import smile.data.DataFrame;
import smile.feature.extraction.Projection;
import smile.math.MathEx;
import smile.math.blas.UPLO;
import smile.math.matrix.Matrix;

public class PCA
extends Projection {
    private static final long serialVersionUID = 2L;
    private final double[] mu;
    private double[] pmu;
    private final Matrix eigvectors;
    private final double[] eigvalues;
    private final double[] proportion;
    private final double[] cumulativeProportion;

    public PCA(double[] mu, double[] eigvalues, Matrix loadings, Matrix projection, String ... columns) {
        super(projection, "PCA", columns);
        this.mu = mu;
        this.eigvalues = eigvalues;
        this.eigvectors = loadings;
        this.proportion = (double[])eigvalues.clone();
        MathEx.unitize1(this.proportion);
        this.cumulativeProportion = new double[eigvalues.length];
        this.cumulativeProportion[0] = this.proportion[0];
        for (int i = 1; i < eigvalues.length; ++i) {
            this.cumulativeProportion[i] = this.cumulativeProportion[i - 1] + this.proportion[i];
        }
        this.pmu = projection.mv(mu);
    }

    public static PCA fit(DataFrame data, String ... columns) {
        double[][] x = data.toArray(columns);
        return PCA.fit(x, columns);
    }

    public static PCA cor(DataFrame data, String ... columns) {
        double[][] x = data.toArray(columns);
        return PCA.cor(x, columns);
    }

    public static PCA fit(double[][] data, String ... columns) {
        Matrix eigvectors;
        double[] eigvalues;
        int m = data.length;
        int n = data[0].length;
        double[] mu = MathEx.colMeans(data);
        Matrix X = Matrix.of(data);
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                X.sub(i, j, mu[j]);
            }
        }
        if (m > n) {
            Matrix.SVD svd = X.svd(true, true);
            eigvalues = svd.s;
            for (int i = 0; i < eigvalues.length; ++i) {
                int n2 = i;
                eigvalues[n2] = eigvalues[n2] * eigvalues[i];
            }
            eigvectors = svd.V;
        } else {
            Matrix cov = new Matrix(n, n);
            for (int k = 0; k < m; ++k) {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        cov.add(i, j, X.get(k, i) * X.get(k, j));
                    }
                }
            }
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j <= i; ++j) {
                    cov.div(i, j, m);
                    cov.set(j, i, cov.get(i, j));
                }
            }
            cov.uplo(UPLO.LOWER);
            Matrix.EVD eigen = cov.eigen(false, true, true).sort();
            eigvalues = eigen.wr;
            eigvectors = eigen.Vr;
        }
        Matrix projection = PCA.getProjection(eigvalues, eigvectors, 0.95);
        return new PCA(mu, eigvalues, eigvectors, projection, columns);
    }

    public static PCA cor(double[][] data, String ... columns) {
        int j;
        int i;
        int i2;
        int m = data.length;
        int n = data[0].length;
        double[] mu = MathEx.colMeans(data);
        Matrix x = Matrix.of(data);
        for (int j2 = 0; j2 < n; ++j2) {
            for (i2 = 0; i2 < m; ++i2) {
                x.sub(i2, j2, mu[j2]);
            }
        }
        Matrix cov = new Matrix(n, n);
        for (int k = 0; k < m; ++k) {
            for (i = 0; i < n; ++i) {
                for (j = 0; j <= i; ++j) {
                    cov.add(i, j, x.get(k, i) * x.get(k, j));
                }
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            for (int j3 = 0; j3 <= i2; ++j3) {
                cov.div(i2, j3, m);
                cov.set(j3, i2, cov.get(i2, j3));
            }
        }
        double[] sd = new double[n];
        for (i = 0; i < n; ++i) {
            sd[i] = Math.sqrt(cov.get(i, i));
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j <= i; ++j) {
                cov.div(i, j, sd[i] * sd[j]);
                cov.set(j, i, cov.get(i, j));
            }
        }
        cov.uplo(UPLO.LOWER);
        Matrix.EVD eigen = cov.eigen(false, true, true).sort();
        Matrix loadings = eigen.Vr;
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j4 = 0; j4 < n; ++j4) {
                loadings.div(i3, j4, sd[i3]);
            }
        }
        Matrix projection = PCA.getProjection(eigen.wr, loadings, 0.95);
        return new PCA(mu, eigen.wr, loadings, projection, columns);
    }

    public double[] center() {
        return this.mu;
    }

    public Matrix loadings() {
        return this.eigvectors;
    }

    public double[] variance() {
        return this.eigvalues;
    }

    public double[] varianceProportion() {
        return this.proportion;
    }

    public double[] cumulativeVarianceProportion() {
        return this.cumulativeProportion;
    }

    private static Matrix getProjection(double[] eigvalues, Matrix loadings, double p) {
        int k;
        if (p <= 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid percentage of variance: " + p);
        }
        double[] proportion = (double[])eigvalues.clone();
        MathEx.unitize1(proportion);
        double sum = 0.0;
        for (k = 0; k < proportion.length && !((sum += proportion[k]) >= p); ++k) {
        }
        return PCA.getProjection(loadings, k + 1);
    }

    private static Matrix getProjection(Matrix loadings, int p) {
        int n = loadings.nrow();
        if (p < 1 || p > n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        Matrix projection = new Matrix(p, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < p; ++j) {
                projection.set(j, i, loadings.get(i, j));
            }
        }
        return projection;
    }

    public PCA getProjection(int p) {
        Matrix projection = PCA.getProjection(this.eigvectors, p);
        return new PCA(this.mu, this.eigvalues, this.eigvectors, projection, this.columns);
    }

    public PCA getProjection(double p) {
        int k;
        if (p <= 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid percentage of variance: " + p);
        }
        for (k = 0; k < this.cumulativeProportion.length && !(this.cumulativeProportion[k] >= p); ++k) {
        }
        return this.getProjection(k);
    }

    @Override
    protected double[] postprocess(double[] x) {
        MathEx.sub(x, this.pmu);
        return x;
    }
}

